<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\Models\Admin; 
use App\Models\Project;
use App\Models\Country; 
use App\Models\Investment; 
use App\Models\State; 
use Auth;
use Validator;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
	
class ProjectController extends Controller
{

   
	public function projects(Request $request)
    {
        
       return response()->json(['data' =>Project::where('status','Active')->get(),'message' => 'Success']);
    } 
	public function projectdetail(Request $request)
    {
		$investor = Auth::guard('sanctum')->user();
        $id = $request->id; 
       return response()->json(['data' =>Project::with(['progressImages','progressVideos','progressImages.images'])->where('id',$id)->where('status','Active')->first(),'data2' =>Investment::where('project_id',$id)->where('investor_id',$investor->id)->orderBy('id','desc')->first(),'message' => 'Success']);
    }  
	
	public function investmentdetail(Request $request)
    {
		$investor = Auth::guard('sanctum')->user();
        $id = $request->id;
		$investment = Investment::where('id',$id)->where('investor_id',$investor->id)->orderBy('id','desc')->first();
		$project = Project::with(['progressImages','progressVideos','progressImages.images'])->where('id',$investment->project_id)->where('status','Active')->first();
       return response()->json(['data' =>$project,'data2' =>$investment,'message' => 'Success']);
    } 
	
	public function getInvestmentsByInvestor(Request $request)
    {
        //$investor = Auth::user(); // Get logged-in investor
		$investor = Auth::guard('sanctum')->user();
        if (!$investor) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }

        $investments = Investment::with(['project','project.progressVideos','project.progressImages'])->where('investor_id', $investor->id)->get();

        return response()->json([
            'status' => true,
            'data' => $investments
        ]);
    }
	 public function acceptInvestmentTerms(Request $request)
    {
        $investor = Auth::guard('sanctum')->user();
        if (!$investor) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }

        $validator = Validator::make($request->all(), [
            'investment_id' => 'required|exists:investments,id',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 422);
        }

        $investment = Investment::where('id', $request->investment_id)
            ->where('investor_id', $investor->id)
            ->first();

        if (!$investment) { 
            return response()->json(['error' => 'Investment not found'], 404);
        }

        // Update investment to mark terms as accepted
        $investment->terms_accepted = true;
        $investment->save();

        return response()->json([
            'status' => true,
            'message' => 'Terms accepted successfully!',
            'data' => $investment
        ]);
    }
	 


}
