<?php

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Controllers\Backend\AdminsController;
use App\Http\Controllers\Backend\Auth\ForgotPasswordController;
use App\Http\Controllers\Backend\Auth\LoginController;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Backend\RolesController;
use App\Http\Controllers\Backend\UsersController;
use App\Http\Controllers\Backend\InvestmentController;
use App\Http\Controllers\Backend\ProjectController;
use App\Http\Controllers\Backend\FranchiseController;
use App\Http\Controllers\API\AuthController;
use Illuminate\Support\Facades\Artisan;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    return "Cache cleared successfully!";
});


Auth::routes();

Route::get('/testmail', [AuthController::class, 'testsendmail']);
Route::get('/', 'HomeController@redirectAdmin')->name('index');
Route::get('/delete-account', function () {
    return view('delete-account'); // make sure this view exists
});
Route::post('/delete-account', function (Request $request) {
    
   $request->validate([
        'email' => 'required|email',
    ]);

    DB::table('delete_account_requests')->insert([
        'email'       => $request->email,
        'ip_address'  => $request->ip(),
        'user_agent'  => $request->header('User-Agent'),
        'created_at'  => now(),
        'updated_at'  => now(),
    ]);

    return redirect('/delete-account')->with('status', 'Your account deletion request has been received. Your account will be  deleted within 90 days.');
});

Route::get('/home', 'HomeController@index')->name('home');
Route::get('/getAdminDetails', [AdminsController::class, 'getAdminDetails']);
/**
 * Admin routes
 */
 Route::get('getstates', [AdminsController::class, 'getStates']);
 
 Route::DELETE('/admin/admins/{admin}/delete-document/{field}', [AdminsController::class, 'deleteDocument'])
    ->name('admin.admins.deleteDocument');
	
	
Route::group(['prefix' => 'admin', 'as' => 'admin.'], function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::resource('roles', RolesController::class);
    Route::resource('admins', AdminsController::class);
	
    Route::resource('users', UsersController::class);
	Route::get('upload/document/{id}', [AdminsController::class, 'uploaddocument'])->name('uploaddocument');
	Route::post('upload/documents', [AdminsController::class, 'postuploadDocuments'])->name('admins.uploadDocuments');
	Route::get('myteam', [AdminsController::class, 'myteamindex'])->name('myteam.index');
    // Login Routes.
    Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
    Route::post('/login/submit', [LoginController::class, 'login'])->name('login.submit');

    // Logout Routes.
    Route::post('/logout/submit', [LoginController::class, 'logout'])->name('logout.submit');

    // Forget Password Routes.
    Route::get('/password/reset', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
    Route::post('/password/reset/submit', [ForgotPasswordController::class, 'reset'])->name('password.update');
	Route::resource('projects', ProjectController::class);
    Route::resource('investments', InvestmentController::class);
	Route::delete('/project-progress/{progress}/delete', [ProjectController::class, 'deleteProgress'])->name('projects.progress.remove');
	Route::get('/remove/progress/image/{id}', [ProjectController::class, 'removeProgressimage'])->name('projects.removeProgressimage');

	
	
})->middleware('auth:admin');
