<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use File;
use Carbon\Carbon;
class ProjectProgress extends Model
{
    use HasFactory;

    protected $fillable = [ 
        'project_id',
        'date',
        'progress_percentage',
    ];

 

    // Relationship with Project
    public function project()
    {
        return $this->belongsTo(Project::class);
    }

  
	
	public function images()
	{
		return $this->hasMany(ProjectProgressImage::class, 'progress_id');
	}
	public function getDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }

}
