@extends('backend.layouts.master')

@section('title', 'Create Project - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Create New Project</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ route('admin.projects.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="form-group">
                            <label>Image<span style="color:red;">*</span></label>
                            <input type="file" name="image" class="form-control-file" required>
                        </div>

                        <div class="form-group">
                            <label>Project Name<span style="color:red;">*</span></label>
                            <input type="text" class="form-control" name="name" required>
                        </div>

                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" name="description"></textarea>
                        </div>
					
                        {{--<div class="form-group">
                            <label>IRR</label>
                            <input type="text" class="form-control" name="target_irr">
                        </div>
					<div class="form-group">
                            <label>ROI</label>
                            <input type="text" class="form-control" name="roi">
                        </div>--}}

                        <div class="form-group">
                            <label>Asset Value</label>
                            <input type="text" class="form-control" name="asset_value">
                        </div>

                        <div class="form-group">
                            <label>Asset Type</label>
                            <input type="text" class="form-control" name="asset_type">
                        </div>

                        <div class="form-group">
                            <label>Minimum Investment</label>
                            <input type="text" class="form-control" name="minimum_investment">
                        </div>
						 <div class="form-group">
                            <label>Upload Term and Condition (PDF)<span style="color:red;">*</span></label>
                            <input type="file" name="term_condition" class="form-control-file" accept=".pdf" required>
                        </div>
						<div class="form-group">
                            <label>Upload Balance Sheet (PDF)</label>
                            <input type="file" name="balance_sheet" class="form-control-file" accept=".pdf">
                        </div>
                        <div class="form-group">
                            <label>Status</label>
                            <select class="form-control" name="status">
                                <option value="Active">Active</option>
                                <option value="Inactive">Inactive</option>
                            </select>
                        </div>

                       <div class="form-group">
                            <label>Launch Status</label>
                            <select class="form-control" name="launching_soon">
                                <option value="1" >Launched</option>
                                <option value="0" >Launching Soon</option>
                            </select>
                        </div>
                        

                        <hr>

                        <h5>Project Progress</h5>

                        <div id="progress-section">
                            <div class="progress-group">
                                <div class="form-group">
                                    <label>Progress Date<span style="color:red;">*</span></label>
                                    <input type="date" name="progress_dates[0]" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label>Progress <span style="color:red;">*</span></label>
                                    <input type="text" name="progress_percentages[0]" class="form-control" required>
                                </div>
                                <div class="form-group">
                                    <label>Upload Progress Images<span style="color:red;">*</span></label>
                                    <input type="file" name="progress_images[0][]" class="form-control-file" accept="image/*" multiple required>
                                </div>
                                <div class="form-group" id="progress-titles-0">
                                    <label>Image Titles</label>
                                </div>
                                <button type="button" class="btn btn-danger remove-progress">Remove</button>
                                <hr>
                            </div>
                        </div>
						<hr>
                        <button type="button" id="add-progress" class="btn btn-success">Add More Progress</button>

                        <br><br>
						
						<h5>Video Progress</h5>

						<div id="video-progress-section">
							<div class="video-progress-group">
								<div class="form-group">
									<label>Video Title</label>
									<input type="text" name="video_titles[0]" class="form-control" placeholder="Enter video title">
								</div>
								<div class="form-group">
									<label>Google Drive Video Link</label>
									<input type="url" name="video_links[0]" class="form-control" placeholder="Paste Google Drive video link">
								</div>
								{{--<button type="button" class="btn btn-danger remove-video-progress">Remove</button>--}}
								<hr>
							</div>
						</div>

						{{--<button type="button" id="add-video-progress" class="btn btn-success">Add More Videos</button>--}}
						<br><br>
                        <button type="submit" class="btn btn-primary">Create</button>
                        <a href="{{ route('admin.projects.index') }}" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    let videoProgressIndex = 1;

    // Add new video progress
    document.getElementById('add-video-progress').addEventListener('click', function () {
        let videoProgressSection = document.getElementById('video-progress-section');
        let newVideoProgress = `
            <div class="video-progress-group">
                <div class="form-group">
                    <label>Video Title</label>
                    <input type="text" name="video_titles[${videoProgressIndex}]" class="form-control" placeholder="Enter video title">
                </div>
                <div class="form-group">
                    <label>Google Drive Video Link</label>
                    <input type="url" name="video_links[${videoProgressIndex}]" class="form-control" placeholder="Paste Google Drive video link">
                </div>
                <button type="button" class="btn btn-danger remove-video-progress">Remove</button>
                <hr>
            </div>
        `;
        videoProgressSection.insertAdjacentHTML('beforeend', newVideoProgress);
        videoProgressIndex++;
    });

    // Remove video progress
    document.addEventListener('click', function (event) {
        if (event.target.classList.contains('remove-video-progress')) {
            event.target.closest('.video-progress-group').remove();
        }
    });
</script>

<script>
    let progressIndex = 1;

    // Add new progress section
    document.getElementById('add-progress').addEventListener('click', function () {
        let progressSection = document.getElementById('progress-section');
        let newProgress = `
            <div class="progress-group">
                <div class="form-group">
                    <label>Progress Date<span style="color:red;">*</span></label>
                    <input type="date" name="progress_dates[${progressIndex}]" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Progress <span style="color:red;">*</span></label>
                    <input type="text" name="progress_percentages[${progressIndex}]" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Upload Progress Images<span style="color:red;">*</span></label>
                    <input type="file" name="progress_images[${progressIndex}][]" multiple class="form-control-file" accept="image/*" required>
                </div>
                <div class="form-group" id="progress-titles-${progressIndex}">
                    <label>Image Titles</label>
                </div>
                <button type="button" class="btn btn-danger remove-progress">Remove</button>
                <hr>
            </div>
        `;
        progressSection.insertAdjacentHTML('beforeend', newProgress);
        progressIndex++;
    });

    // Remove progress section
    document.addEventListener('click', function (event) {
        if (event.target.classList.contains('remove-progress')) {
            event.target.closest('.progress-group').remove();
        }
    });

    // Add titles for uploaded images
    document.addEventListener('change', function (event) {
        if (event.target.matches('input[type="file"][name^="progress_images"]')) {
            let fileInput = event.target;
            let progressGroup = fileInput.closest('.progress-group');
            let progressTitlesDiv = progressGroup.querySelector(`[id^="progress-titles-"]`);
            progressTitlesDiv.innerHTML = '<label>Image Titles</label>';
            Array.from(fileInput.files).forEach((file, index) => {
                let titleInput = document.createElement('input');
                titleInput.type = 'text';
                titleInput.name = `${fileInput.name.replace('progress_images', 'progress_titles')}[${index}]`;
                titleInput.className = 'form-control';
                titleInput.placeholder = `Enter title for ${file.name}`;
                progressTitlesDiv.appendChild(titleInput);
            });
        }
    });
</script>

@endsection