<!DOCTYPE html>
<html lang="en">
<head> 
    <meta charset="UTF-8">
    <title>Account Already Approved - Gio Realty</title>
    <meta http-equiv="refresh" content="5;url={{ $loginUrl }}">
    <style>
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            background: linear-gradient(135deg, #004080, #0073e6);
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .card {
            background: #fff;
            padding: 40px;
            border-radius: 16px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.15);
            text-align: center;
            max-width: 500px;
            width: 100%;
        }
        .icon {
            font-size: 70px;
            color: #f39c12;
            margin-bottom: 20px;
        }
        h1 {
            color: #004080;
            margin-bottom: 15px;
            font-size: 24px;
        }
        p {
            color: #555;
            font-size: 16px;
        }
        .btn {
            background: #004080;
            color: #fff;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: bold;
            display: inline-block;
            margin-top: 20px;
        }
        .btn:hover {
            background: #0066cc;
        }
        .note {
            margin-top: 20px;
            color: #888;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="card">
        <div class="icon">⚠️</div>
        <h1>Hello, {{ $investor2->name }}</h1>
        <p>Your investor account is <strong>already approved</strong>.</p>
        <a href="{{ $loginUrl }}" class="btn">Go to Login</a>
    </div>
</body>
</html>
