<?php

declare(strict_types=1);

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $adminId = $this->route('admin');

        return [
            /* 'title' => 'required|string|max:10', // Mr/Ms
            'first_name' => 'required|string|max:50',
            'middle_name' => 'nullable|string|max:50', // Non-mandatory
            'last_name' => 'required|string|max:50',
            'father_name' => 'required|string|max:50', 
            'mobile' => 'required|max:15|unique:admins,mobile,' . $adminId,
            'pan' => 'nullable|string|max:10|unique:admins,pan,' . $adminId,
            'aadhar_number' => 'nullable|string|max:12|unique:admins,pan,' . $adminId,*/
            'email' => 'required|max:100|email|unique:admins,email,' . $adminId,
            'address' => 'nullable|string|max:255', // Optional
            'state' => 'required|string|max:50',
            'city' => 'required|string|max:50',
            //'years_of_exp' => 'required|integer|min:0', // Years of experience
            //'company_name' => 'nullable|string|max:100', // Non-mandatory
            //'company_gst' => 'nullable|string', // Non-mandatory
            //'education_qualification' => 'required|string|in:Masters,Graduate,Diploma,High School', // Dropdown
            'username' => 'required|max:100|unique:admins,username,' . $adminId,
            'password' => $adminId ? 'nullable|min:6|confirmed' : 'required|min:6|confirmed',

            // Nominee details (Optional)
            /* 'nominee_name' => 'nullable|string|max:50',
            'nominee_relationship' => 'nullable|string|max:50',
            'nominee_contact' => 'nullable|string|max:15',*/

            // Bank details (Optional)
            'bank_name' => 'nullable|string|max:100',
            'account_number' => 'nullable|string|max:20',
            'ifsc_code' => 'nullable|string|max:11',
            'account_type' => 'nullable|string|in:Savings,Current', // Example types 
        ];
    }
}
