<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Database\Eloquent\Model;
 
class Project extends Model
{
  
    
   

    protected $fillable = [
        'name', 'image','description', 'status', 'launching_soon', 'target_irr', 'asset_value', 'asset_type', 'minimum_investment'
    ];
	protected $appends = ['image_url'];
	
	public function getImageUrlAttribute()
    {
        return $this->image ? asset($this->image) : ""; // Fallback to a default image if none is uploaded
    }
   
}
