@extends('backend.layouts.master')

@section('title')
    {{ __('Investors - Admin Panel') }}
@endsection

@section('styles')
    <!-- Start datatable css -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.18/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.jqueryui.min.css">
    
@endsection

@section('admin-content')

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">{{ __('Investors') }}</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li><span>{{ __('All Investors') }}</span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            @include('backend.layouts.partials.logout')
        </div>
    </div>
</div>
<!-- page title area end -->

<div class="main-content-inner">
    <div class="row">
        <!-- data table start -->
        <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title float-left">{{ __('Investors') }}</h4>
                    <p class="float-right mb-2">
                        @if (auth()->user()->can('investor.edit'))
                            <a class="btn btn-primary text-white" href="{{ route('admin.admins.create') }}">
                                <i class="fa fa-plus"></i> {{ __('Create New Investor') }}
                            </a>
                        @endif
                    </p>
                    <div class="clearfix"></div>
                    <div class="data-tables">
                        @include('backend.layouts.partials.messages')
                        <table id="admins-table" class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Mobile</th>
                                    <th>Email</th>
                                    <th>Address</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($admins as $admin)
                                     <tr>
										<td>{{ $admin->first_name }}</td>
										<td>{{ $admin->last_name }}</td>
										<td>{{ $admin->mobile }}</td>
										<td>{{ $admin->email }}</td>
										<td>{{ $admin->address }}</td>
										<td>
											@if (auth()->user()->can('investor.edit'))
												<a class="btn btn-sm btn-primary text-white" href="{{ route('admin.admins.edit', $admin->id) }}">
													Edit
												</a>
											@endif

											@if (auth()->user()->can('investor.delete'))
												<button class="btn btn-sm btn-danger text-white" onclick="handleDelete({{ $admin->id }})">
													Delete
												</button>
												<form id="delete-form-{{ $admin->id }}" action="{{ route('admin.admins.destroy', $admin->id) }}" method="POST" style="display: none;">
													@method('DELETE')
													@csrf
												</form>
											@endif
										</td>
									</tr>

                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- data table end -->
    </div>
</div>
@endsection

@section('scripts')
    <!-- Start datatable js -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.3/js/responsive.bootstrap.min.js"></script>

    <script>
  

    // Toggle child rows on parent row click (for the plus button)
    $('#admins-table').on('click', '.toggle-children', function() {
		//alert();
        var tr = $(this).closest('tr');
        var row = $(this).closest(tr);
        var parentId = tr.data('id');

        // Find the corresponding child row
        var childRow = $('tr.child-row[data-parent-id="' + parentId + '"]');

        if (childRow.is(':visible')) {
            // Hide the child row and change the plus sign to minus
            childRow.hide();
            $(this).text('+'); // Plus sign to expand
        } else {
            // Show the child row and change the plus sign to minus
            childRow.show();
            $(this).text('-'); // Minus sign to collapse
        }

        // Manually redraw the table to avoid _DT_CellIndex errors
        //table.responsive.recalc();
        //table.draw();
    
});




        // Format child row data
        function formatChildRow(data) {
            var admin = data[0]; // Assume first column contains the admin object
            var childrenHtml = `
                <table class="table table-bordered">
                    <tr><td colspan="9"><strong>Children:</strong></td></tr>
                    ${admin.children.map(child => `
                        <tr>
                            <td style="padding-left: 20px;">${child.name}</td>
                            <td>${child.level}</td>
                            <td>${child.referral_id}</td>
                            <td>${child.first_name}</td>
                            <td>${child.last_name}</td>
                            <td>${child.mobile}</td>
                            <td>${child.email}</td>
                            <td>${child.address}</td>
                            <td></td>
                        </tr>
                    `).join('')}
                </table>
            `;
            return childrenHtml;
        }

        // Handle delete action with confirmation modal
        function handleDelete(adminId) {
            if (confirm('Are you sure you want to delete this user?')) {
                document.getElementById(`delete-form-${adminId}`).submit();
            }
        }
    </script>
@endsection
