@extends('backend.layouts.master')

@section('title', 'Create Project - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Create New Project</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
				@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
                   <form action="{{ route('admin.projects.store') }}" method="POST" enctype="multipart/form-data">
						@csrf
						<div class="form-group">
                            <label>Image</label>
                            <input type="file" name="image" class="form-control-file" required>
                        </div>
						<div class="form-group">
							<label>Project Name</label>
							<input type="text" class="form-control" name="name" required>
						</div>
						<div class="form-group">
							<label>Description</label>
							<textarea class="form-control" name="description"></textarea>
						</div>
						
						<div class="form-group">
							<label>Target IRR</label>
							<input type="text" class="form-control" name="target_irr">
						</div>
						<div class="form-group">
							<label>Asset Value</label>
							<input type="text" class="form-control" name="asset_value">
						</div>
						<div class="form-group">
							<label>Asset Type</label>
							<input type="text" class="form-control" name="asset_type">
						</div>
						<div class="form-group">
							<label>Minimum Investment</label>
							<input type="text" class="form-control" name="minimum_investment">
						</div>
						<div class="form-group">
							<label>Status</label>
							<select class="form-control" name="status">
								<option value="Active">Active</option>
								<option value="Inactive">Inactive</option>
							</select>
						</div>
						<div class="form-check">
							<input type="checkbox" class="form-check-input" name="launching_soon" id="launchingSoon">
							<label class="form-check-label" for="launchingSoon">Launching Soon</label>
						</div>
						<br>
						<button type="submit" class="btn btn-primary">Create</button>
						<a href="{{ route('admin.projects.index') }}" class="btn btn-secondary">Cancel</a>
					</form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
