@extends('backend.layouts.master')

@section('title', 'Edit Project - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Edit Project</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
				@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
                   <form action="{{ route('admin.projects.update', $project->id) }}" method="POST" enctype="multipart/form-data">
						@csrf @method('PUT')
						<div class="form-group">
                            <label>Existing Image</label><br>
                            @if ($project->image)
                                <img src="{{ asset($project->image) }}" alt="Project Image" class="img-thumbnail" width="100px">
                            @else
                                <p>No image uploaded</p>
                            @endif
                        </div>

                        <div class="form-group">
                            <label>Change Image</label>
                            <input type="file" name="image" class="form-control-file">
                        </div>
						<div class="form-group">
							<label>Project Name</label>
							<input type="text" class="form-control" name="name" value="{{ $project->name }}" required>
						</div>
						<div class="form-group">
							<label>Description</label>
							<textarea class="form-control" name="description">{{ $project->description }}</textarea>
						</div>
						<div class="form-group">
							<label>Target IRR</label>
							<input type="text" class="form-control" name="target_irr" value="{{ $project->target_irr }}">
						</div>
						<div class="form-group">
							<label>Asset Value</label>
							<input type="text" class="form-control" name="asset_value" value="{{ $project->asset_value }}">
						</div>
						<div class="form-group">
							<label>Asset Type</label>
							<input type="text" class="form-control" name="asset_type" value="{{ $project->asset_type }}">
						</div>
						<div class="form-group">
							<label>Minimum Investment</label>
							<input type="text" class="form-control" name="minimum_investment" value="{{ $project->minimum_investment }}">
						</div>
						<div class="form-group">
							<label>Status</label>
							<select class="form-control" name="status">
								<option value="Active" {{ $project->status == 'Active' ? 'selected' : '' }}>Active</option>
								<option value="Inactive" {{ $project->status == 'Inactive' ? 'selected' : '' }}>Inactive</option>
							</select>
						</div>
						<div class="form-check">
							<input type="checkbox" class="form-check-input" name="launching_soon" id="launchingSoon" {{ $project->launching_soon ? 'checked' : '' }}>
							<label class="form-check-label" for="launchingSoon">Launching Soon</label>
						</div>
						<br>
						<button type="submit" class="btn btn-primary">Update</button>
						<a href="{{ route('admin.projects.index') }}" class="btn btn-secondary">Cancel</a>
					</form>

                </div>
            </div>
        </div>
    </div>
</div>

@endsection
