@extends('backend.layouts.master')

@section('title', 'All Projects - Admin Panel')

@section('admin-content')

<div class="page-title-area">
    <h4 class="page-title">All Projects</h4>
</div>

<div class="main-content-inner">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <a href="{{ route('admin.projects.create') }}" class="btn btn-primary mb-3">Create New Project</a>
                  <table class="table">
					<thead>
						<tr>
							<th>Image</th>
							<th>Name</th>
							<th>Status</th>
							<th>Launching Soon</th>
							<th>Asset Type</th>
							<th>Actions</th>
						</tr>
					</thead>
					<tbody>
						@foreach($projects as $project)
							<tr>
								<td> @if ($project->image)
                                <img src="{{ asset($project->image) }}" alt="Project Image" class="img-thumbnail" width="50px" height="50px">
                            @else
                                <p>No image uploaded</p>
                            @endif</td>
								<td>{{ $project->name }}</td>
								<td>
									<span class="badge {{ $project->status == 'Active' ? 'badge-success' : 'badge-danger' }}">
										{{ $project->status }}
									</span>
								</td>
								<td>
									@if($project->launching_soon)
										<span class="badge badge-primary">Yes</span>
									@else
										<span class="badge badge-secondary">No</span>
									@endif
								</td>
								<td>{{ $project->asset_type }}</td>
								<td>
									<a href="{{ route('admin.projects.show', $project->id) }}" class="btn btn-info btn-sm">View</a>
									<a href="{{ route('admin.projects.edit', $project->id) }}" class="btn btn-warning btn-sm">Edit</a>
									<form action="{{ route('admin.projects.destroy', $project->id) }}" method="POST" style="display:inline;">
										@csrf @method('DELETE')
										<button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
									</form>
								</td>
							</tr>
						@endforeach
					</tbody>
				</table>

                </div>
            </div>
        </div>
    </div>
</div>

@endsection
