<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class Project extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'image', 'description', 'status', 'launching_soon', 'target_irr', 'roi', 'asset_value', 'asset_type', 'minimum_investment','balance_sheet',
        'term_condition',
    ];

    protected $appends = ['image_url', 'term_condition_url', 'balance_sheet_url']; 

    // Append full URL for image
    public function getImageUrlAttribute()
    {
        if ($this->image) {
            // Check if the image file exists in the public path
            $imagePath = public_path($this->image);
            return file_exists($imagePath) ? asset($this->image) : null;
        }
        return null;
    }

    // Relationship with ProjectProgress model
    public function progressImages()
    {
        return $this->hasMany(ProjectProgress::class);
    }
	 public function getTermConditionUrlAttribute()
    {
        return $this->term_condition ? asset($this->term_condition) : null;
    }
	public function getBalanceSheetUrlAttribute()
    {
        return $this->balance_sheet ? asset($this->balance_sheet) : null;
    }
	public function progressVideos()
	{
		return $this->hasMany(ProjectVideo::class);
	}
	public function getCreatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
	public function getUpdatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }

	
}
