@extends('backend.layouts.master')

@section('title', 'Investment Details - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Investment Details</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Investment Information</h5>
                    <table class="table table-bordered">
                        <tr>
                            <th>Investor Name</th>
                            <td>{{ $investment->investor->name }}</td>
                        </tr>
                        <tr>
                            <th>Project Name</th>
                            <td>{{ $investment->project->name }}</td>
                        </tr>
                        <tr>
                            <th>Amount Invested</th>
                            <td>{{ number_format($investment->amount_invested, 2) }}</td>
                        </tr>
                        <tr>
                            <th>Share Price</th>
                            <td>{{ number_format($investment->share_price, 2) }}</td>
                        </tr>
                        <tr>
                            <th>Transaction Number</th>
                            <td>{{ $investment->transaction_number }}</td>
                        </tr>
                        <tr>
                            <th>Transaction Date</th>
                            <td>{{ date('d M Y', strtotime($investment->transaction_date)) }}</td>
                        </tr>
                        <tr>
                            <th>Share Certificate</th>
                            <td>
                                @if($investment->share_certificate)
                                    <a href="{{ asset($investment->share_certificate) }}" target="_blank" class="btn btn-primary btn-sm">
                                        View Certificate 📄
                                    </a>
                                @else
                                    <span class="text-danger">No file uploaded</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Terms & Conditions</th>
                            <td>
                                @if($investment->term_condition)
                                    <a href="{{ asset($investment->term_condition) }}" target="_blank" class="btn btn-primary btn-sm">
                                        View Terms 📄
                                    </a>
                                @else
                                    <span class="text-danger">No file uploaded</span>
                                @endif
                            </td>
                        </tr>
                    </table>

                    <a href="{{ route('admin.investments.index') }}" class="btn btn-secondary">Back</a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
