<?php

namespace App\Models; 

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class Projectshareprice extends Model
{
    use HasFactory;

    protected $fillable = [ 
        
        'project_id',
        'share_price',
        'transaction_date',
    ];

   
    public function project()
    {
        return $this->belongsTo(Project::class);
    }
	public function getTransactionDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
	public function getCreatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
	public function getUpdatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
}
 