@extends('backend.layouts.master')

@section('title', 'Edit Project Share Price - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Edit Project Share Price</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.projectshareprice.update', $projectshareprice->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                      

                        <div class="form-group">
                            <label>Project</label>
                            <select class="form-control" name="project_id" required>
                                @foreach($projects as $project)
                                    <option value="{{ $project->id }}" {{ $projectshareprice->project_id == $project->id ? 'selected' : '' }}>
                                        {{ $project->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        
                        <div class="form-group">
                            <label>Share Price</label>
                            <input type="text" class="form-control" name="share_price" value="{{ $projectshareprice->share_price }}" required>
                        </div>
						
                       

                        <div class="form-group">
                           
                            <div class="row">
								
                                <div class="col-md-6">
                                    <label>Transaction Date</label>
                                    <input type="date" class="form-control" name="transaction_date" value="{{ $projectshareprice->transaction_date }}" required>
                                </div>
                            </div>
                        </div>

                        <br>
                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="{{ route('admin.projectshareprice.index') }}" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
