@extends('backend.layouts.master')

@section('title')
Upload Documents - Admin Panel
@endsection

@section('styles')
<style>
    .file-preview img, .file-preview .pdf-icon {
        max-width: 100%;
        max-height: 150px;
        border: 1px solid #ddd;
        padding: 5px;
        margin-top: 10px;
    }
    .pdf-icon {
        display: inline-block;
        width: 100px;
        height: 100px;
        background: url('/path-to-pdf-icon.png') no-repeat center center;
        background-size: contain;
    }
</style>
@endsection

@section('admin-content')
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <h4 class="page-title">Upload Documents</h4>
        </div>
    </div>
</div>

<div class="main-content-inner">
    <div class="row">
        <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body"> 
                    <h4 class="header-title">Upload Documents</h4>
                    @include('backend.layouts.partials.messages')

                    <form action="{{ route('admin.admins.uploadDocuments') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="admin_id" value="{{ $admin->id }}">

                        <div class="row">
                            @php
                                $documents = [
                                    'aadhar_card_doc' => 'Aadhaar Card',
                                    'pan_card_doc' => 'PAN Card',
                                    'company_gst_certificate' => 'GST Certificate',
                                    'company_pan' => 'Company PAN'
                                ];
                            @endphp

                            @foreach($documents as $key => $label)
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{ $label }}</label>
                                    <input type="file" name="{{ $key }}" class="form-control">
                                    @if(!empty($admin->$key))
                                        <div class="file-preview" id="preview-{{ $key }}">
                                            <a href="{{ asset($admin->$key) }}" target="_blank">
                                                @if(pathinfo($admin->$key, PATHINFO_EXTENSION) == 'pdf')
                                                   <i class="fa fa-file-pdf-o text-danger" style="font-size: 100px;"></i>
                                                @else
                                                    <img src="{{ asset($admin->$key) }}" alt="{{ $label }}">
                                                @endif
                                            </a>
											
                                            <button type="button" class="btn btn-outline-danger btn-sm delete-btn" data-id="{{ $admin->id }}" data-doc="{{ $key }}"><i class="fa-solid fa fa-trash"></i> </button>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            @endforeach
                        </div>
                        <button type="submit" class="btn btn-primary mt-3">Upload Documents</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener("DOMContentLoaded", function () {
    document.querySelectorAll(".delete-btn").forEach(button => {
        button.addEventListener("click", function () {
            let adminId = this.getAttribute("data-id");
            let documentName = this.getAttribute("data-doc");
            let previewDiv = document.getElementById("preview-" + documentName);

            if (confirm("Are you sure you want to delete this document?")) {
                let deleteUrl = `{{ url('/admin/admins') }}/${adminId}/delete-document/${documentName}`;
                
                fetch(deleteUrl, {
                    method: "POST",  // Laravel में DELETE method भेजने के लिए POST ही यूज़ करें
                    headers: {
                        "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').getAttribute("content"),
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify({ _method: "DELETE" })  // DELETE method spoofing
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP error! Status: ${response.status}`);
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        previewDiv.remove();  // प्रीव्यू हटाएं
                        alert("Document deleted successfully!");
                    } else {
                        alert("Error deleting document!");
                    }
                })
                .catch(error => console.error("Error:", error));
            }
        });
    });
});

</script>

@endsection
