@extends('backend.layouts.master')

@section('title', 'Investments - Admin Panel')
 
@section('admin-content')
@section('styles')
    <!-- DataTables Bootstrap 4 CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css">
    <!-- DataTables Responsive CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap4.min.css">
@endsection

<style>
.btn-sm {
    padding: 4px 8px !important;
}
</style>

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">{{ __('Investments') }}</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li><span>{{ __('All Investments') }}</span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            @include('backend.layouts.partials.logout')
        </div>
    </div>
</div>
<!-- page title area end -->



<div class="main-content-inner">
    <div class="row">
         <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body">
				<h4 class="header-title float-left">{{ __('Investments') }}</h4>
                    <p class="float-right mb-2">
                         <a href="{{ route('admin.investments.create') }}" class="btn btn-primary btn-sm">Add Investment</a>
                    </p>
                    <table id="investments-table" class=" table table-bordered table-striped table-responsive">
                        <thead>
                            <tr>
							
                                <th>#</th>
                                <th>Investor</th>
                                <th>Project</th>
                                <th>Terms and Conditions</th> 
                                <th>Amount Invested</th>
                                <th>Number Of Shares</th>
                                <th>Share Price</th>
                                <th>Transaction Date</th>
                                <th>Documents</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($investments as $key => $investment)
                                <tr> 
								<td>{{ $key+1 }}</td>
                                    <td>{{ $investment->investor->name ?? "" }}<br>{{ $investment->investor->email ?? "" }}</td>
                                    <td>{{ $investment->project->name ?? "" }}</td>
									<td>
										@if($investment->terms_accepted) 
											✅ Accepted
										@else 
											❌ Not Accepted
										@endif
									</td>
                                    <td>{{ $investment->amount_invested ?? "" }}</td>
                                    <td>{{ $investment->number_of_share ?? "" }}</td>
                                    <td>{{ $investment->share_price ?? "" }}</td>
                                 <td>
  {{ $investment->transaction_date ? \Carbon\Carbon::parse($investment->transaction_date)->format('d-m-Y') : '' }}
</td>

                                  <td>
									<div class="btn-group" role="group">
										@if($investment->share_certificate_url)
											<a href="{{ $investment->share_certificate_url }}" target="_blank" class="btn btn-info btn-sm" title="View Share Certificate">
												📜 Certificate
											</a>
										@else
											<button class="btn btn-info btn-sm coming-soon" title="Coming Soon">📜 Certificate</button>
										@endif

										@if($investment->term_condition_url)
											<a href="{{ $investment->term_condition_url }}" target="_blank" class="btn btn-warning btn-sm" title="View Terms & Conditions">
												📄 Terms
											</a>
										@else
											<button class="btn btn-warning btn-sm coming-soon" title="Coming Soon">📄 Terms</button>
										@endif

										@if($investment->balance_sheet_url)
											<a href="{{ $investment->balance_sheet_url }}" target="_blank" class="btn btn-success btn-sm" title="View Balance Sheet">
												📊 Sheet
											</a>
										@else
											<button class="btn btn-success btn-sm coming-soon" title="Coming Soon">📊 Sheet</button>
										@endif
									</div>
								</td>


                                    <td>
									  <div class="btn-group" role="group">
                                        <a href="{{ route('admin.investments.edit', $investment->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                        <form action="{{ route('admin.investments.destroy', $investment->id) }}" method="POST" style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                        </form>
                                    </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
					<!-- Coming Soon Modal -->
<!-- Bootstrap Modal -->
<div class="modal fade" id="comingSoonModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Coming Soon</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              This document will be available soon. Please try again later.
            </div>
            <div class="modal-footer">
                <button  id="closeModalBtn" type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
    <!-- jQuery (Ensure it is loaded before DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function () {
            $('#investments-table').DataTable({
                "responsive": true,
                "ordering": true,
                "paging": true,
                "searching": true
            });
			
			


        });
		
    </script>
	<script>
			document.addEventListener("DOMContentLoaded", function () {
    var modalElement = document.getElementById("comingSoonModal");
    var myModal = new bootstrap.Modal(modalElement);

    // Open Modal on Button Click
    document.querySelectorAll(".coming-soon").forEach(function (btn) {
        btn.addEventListener("click", function () {
            myModal.show();
        });
    });

    // Close Modal on Close Button Click
    document.getElementById("closeModalBtn").addEventListener("click", function () {
        myModal.hide();
    });
});



    </script>
@endsection
