@extends('backend.layouts.master')

@section('title')
Investor Edit - Admin Panel
@endsection

@section('styles')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .form-check-label {
        text-transform: capitalize;
    }
</style>
@endsection

@section('admin-content')

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">Investor Request Edit</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                    <li><a href="{{ route('admin.investorsrequest.index') }}">All Investors Request List </a></li>
                    <li><span>Edit Investor Request - {{ $admin->name }}</span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            @include('backend.layouts.partials.logout')
        </div>
    </div>
</div>
<!-- page title area end -->

<div class="main-content-inner">
    <div class="row">
        <!-- data table start -->
        <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Edit Investor Request- {{ $admin->name }}</h4>
                    @include('backend.layouts.partials.messages')

                    <form action="{{ route('admin.investorsrequest.update', $admin->id) }}" method="POST">
                        @method('PUT')
                        @csrf
						<hr>
                        <h4 class="mt-4">Personal Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="title">Mr/Ms<span style="color:red;">*</span></label>
                                <select name="title" id="title" class="form-control" required>
                                    <option value="Mr" {{ $admin->title === 'Mr' ? 'selected' : '' }}>Mr</option>
                                    <option value="Ms" {{ $admin->title === 'Ms' ? 'selected' : '' }}>Ms</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="first_name">First Name<span style="color:red;">*</span></label>
                                <input type="text" class="form-control" id="first_name" name="first_name" placeholder="Enter First Name" value="{{ $admin->first_name }}" required>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="middle_name">Middle Name</label>
                                <input type="text" class="form-control" id="middle_name" name="middle_name" placeholder="Enter Middle Name" value="{{ $admin->middle_name }}" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="last_name">Last Name<span style="color:red;">*</span></label>
                                <input type="text" class="form-control" id="last_name" name="last_name" placeholder="Enter Last Name" value="{{ $admin->last_name }}" required>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="father_name">Father's Name</label>
                                <input type="text" class="form-control" id="father_name" name="father_name" placeholder="Enter Father's Name" value="{{ $admin->father_name }}">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="mobile">Mobile No<span style="color:red;">*</span></label>
                                <input type="number" class="form-control" id="mobile" name="mobile" placeholder="Enter Mobile No" value="{{ $admin->mobile }}" required>
                            </div>
                        </div>

                        <div class="form-row">
							<div class="form-group col-md-6 col-sm-12">
                                <label for="whatsapp">WhatsApp No (If different)</label>
                                <input type="number" class="form-control" id="whatsapp" name="whatsapp" placeholder="Enter WhatsApp No" value="{{ $admin->whatsapp }}">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="email">Email ID<span style="color:red;">*</span></label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email ID" value="{{ $admin->email }}" required>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="address">Address</label>
                                <input type="text" class="form-control" id="address" name="address" placeholder="Enter Address" value="{{ $admin->address }}" >
                            </div>
							<div class="form-group col-md-6 col-sm-12">
                                <label for="pincode">Pincode</label>
                                <input type="text" class="form-control" id="pincode" name="pincode" placeholder="Enter pincode" value="{{ $admin->pincode }}" >
                            </div>
                        </div>

                        <div class="form-row">
                           <div class="form-group col-md-6 col-sm-12">
                                <label for="country">Country</label>
                                <select name="country" id="country" class="form-control" >
                                    <option value="">Select Country</option>
                                    @foreach ($countries as $country)
                                        <option value="{{ $country->country_id }}" {{ $admin->country_id === $country->country_id ? 'selected' : '' }}>{{ $country->name }}</option>
                                    @endforeach
                                </select>
                            </div> 
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="state">State</label>
                                <select name="state" id="state" class="form-control" >
                                    <option value="">Select State</option>
                                    @foreach ($states as $state)
                                        <option value="{{ $state->state_id }}" {{ $admin->state_id === $state->state_id ? 'selected' : '' }}>{{ $state->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="city">City</label>
                                <input type="text" class="form-control" id="city" name="city" placeholder="Enter City" value="{{ $admin->city }}" >
                            </div>
                        </div>

                        <div class="form-row">
						{{-- <div class="form-group col-md-6 col-sm-12">
                                <label for="years_of_exp">Years of Experience in Real Estate</label>
                                <input type="number" class="form-control" id="years_of_exp" name="years_of_exp" placeholder="Enter Years of Experience" value="{{ $admin->years_of_exp }}" >
						</div>--}}
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="company_name">Company Name </label>
                                <input type="text" class="form-control" id="company_name" name="company_name" placeholder="Enter Company Name" value="{{ $admin->company_name }}">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="company_gst">Company GST </label>
                                <input type="text" class="form-control" id="company_gst" name="company_gst" placeholder="Enter Company GST" value="{{ $admin->company_gst }}">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="education_qualification">Education Qualification</label>
                                <select name="education_qualification" id="education_qualification" class="form-control" >
                                    <option value="Masters" {{ $admin->education_qualification === 'Masters' ? 'selected' : '' }}>Masters</option>
                                    <option value="Graduate" {{ $admin->education_qualification === 'Graduate' ? 'selected' : '' }}>Graduate</option>
                                    <option value="Diploma" {{ $admin->education_qualification === 'Diploma' ? 'selected' : '' }}>Diploma</option>
                                    <option value="High School" {{ $admin->education_qualification === 'High School' ? 'selected' : '' }}>High School</option>
                                </select>
                            </div>
                        </div>

                       
						<div class="form-row">
							<div class="form-group col-md-6 col-sm-12">
								<label for="added_by_personal_id">Referral ID<span style="color:red;">*</span></label>
								<input type="text" class="form-control" id="added_by_personal_id" name="added_by_personal_id" placeholder="Enter Referral ID"  value="{{ $admin->added_by_personal_id }}" required>
								<div id="admin-details" class="mt-2" style="display: none;"></div>
							</div>
						</div>

						<div class="form-row">
						<div class="form-group col-md-6 col-sm-12">
							<label for="aadhar_number">Aadhar Number</label>
							<input type="text" class="form-control" id="aadhar_number" name="aadhar_number" value="{{ old('aadhar_number', $admin->aadhar_number) }}" placeholder="Enter Aadhar Number">
						</div>
						<div class="form-group col-md-6 col-sm-12">
							<label for="pan">PAN Number</label>
							<input type="text" class="form-control" id="pan" name="pan" value="{{ old('pan', $admin->pan) }}" placeholder="Enter PAN">
						</div>
						</div>
						{{--  <div class="form-row">
                            
                            <div class="form-group col-md-12 col-sm-12">
                                <label for="username">Username</label>
                                <input type="text" class="form-control" id="username" name="username" placeholder="Enter Username"  value="{{ $admin->username }}">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="password">Password </label>
                                <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="password_confirmation">Confirm Password </label>
                                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Enter Password">
                            </div>
                        </div>--}}
                        <!-- Nominee Details -->
						<hr>
                        <h4 class="mt-4">Nominee Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_name">Nominee Name </label>
                                <input type="text" class="form-control" id="nominee_name" name="nominee_name" placeholder="Enter Nominee Name" value="{{ old('nominee_name', $admin->nominee_name) }}" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_relationship">Nominee Relationship </label>
                                <input type="text" class="form-control" id="nominee_relationship" name="nominee_relationship" placeholder="Enter Nominee Relationship" value="{{ old('nominee_relationship', $admin->nominee_relationship) }}" >
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_contact">Nominee Contact No </label>
                                <input type="number" class="form-control" id="nominee_contact" name="nominee_contact" placeholder="Enter Nominee Contact No" value="{{ old('nominee_contact', $admin->nominee_contact) }}" >
                            </div>
                        </div>
<hr>
                        <!-- Bank Details -->
                        <h4 class="mt-4">Bank Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="bank_name">Bank Name </label>
                                <input type="text" class="form-control" id="bank_name" name="bank_name" placeholder="Enter Bank Name" value="{{ old('bank_name', $admin->bank_name) }}" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="account_number">Account Number </label>
                                <input type="text" class="form-control" id="account_number" name="account_number" placeholder="Enter Account Number" value="{{ old('account_number', $admin->account_number) }}" >
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="ifsc_code">IFSC Code </label>
                                <input type="text" class="form-control" id="ifsc_code" name="ifsc_code" placeholder="Enter IFSC Code" value="{{ old('ifsc_code', $admin->ifsc_code) }}" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="account_type">Account Type </label>
                                <select name="account_type" id="account_type" class="form-control" >
                                    <option value="Savings" {{ $admin->account_type === 'Savings' ? 'selected' : '' }}>Savings</option>
                                    <option value="Current" {{ $admin->account_type === 'Current' ? 'selected' : '' }}>Current</option>
                                </select>
                            </div>
                        </div>

                      

                        <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">Save</button>
                        <a href="{{ route('admin.admins.index') }}" class="btn btn-secondary mt-4 pr-4 pl-4">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
        <!-- data table end -->
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2();

        // Load states when country changes
        $('#country').on('change', function() {
            var countryId = $(this).val();
            
            if (countryId) {
                $.ajax({
                    url: '{{url("getstates")}}', // Your route to get states
                    type: 'GET',
                    data: { country_id: countryId },
                    success: function(data) {
                        $('#state').empty();
                        $('#state').append('<option value="">Select State</option>');
                        $.each(data, function(key, value) {
                            $('#state').append('<option value="' + value.state_id + '">' + value.name + '</option>');
                        });

                        // Pre-select state if it exists in the fetched states
                        var currentStateId = '{{ $admin->state_id }}';
                        if (currentStateId) {
                            $('#state').val(currentStateId).trigger('change');
                        }
                    }
                });
            } else {
                $('#state').empty();
                $('#state').append('<option value="">Select State</option>');
            }
        });

        // Trigger the change event on page load to set states correctly
        $('#country').trigger('change');
    });
</script>

<script>
    $(document).ready(function() {
        $('.select2').select2();

        // Load states when country changes
        $('#country').on('change', function() {
            // ... existing state loading code ...
        });

        // Trigger the change event on page load to set states correctly
        $('#country').trigger('change');

        // Handle input for Referral ID
       /*  $('#my_referral_id').on('input', function() {
            var referralId = $(this).val();
            if (referralId) {
                $.ajax({
                    url: '{{ url("getAdminDetails") }}', // Your route to fetch admin details
                    type: 'GET',
                    data: { referral_id: referralId },
                    success: function(data) {
                        var detailsHtml = `
                            <strong>Referral Details:</strong><br>
                            Name: ${data.name}<br>
                            Email: ${data.email}<br>
                            <!-- Add more fields as necessary -->
                        `;
                        $('#admin-details').html(detailsHtml).show();
                    },
                    error: function() {
                        $('#admin-details').html('<span class="text-danger">No admin found with this Referral ID</span>').show();
                    }
                });
            } else {
                $('#admin-details').hide();
            }
        });

        // Trigger fetching of details for the existing Referral ID on page load
        $('#my_referral_id').trigger('input'); */
    });
</script>

@endsection
