@extends('backend.layouts.master')

@section('title')
    {{ __('Investor Details - Admin Panel') }}
@endsection

@section('admin-content')

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">{{ __('Investor Details') }}</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li><a href="{{ route('admin.investorsrequest.index') }}">{{ __('Investors') }}</a></li>
                    <li><span>{{ __('Investor Details') }}</span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            @include('backend.layouts.partials.logout')
        </div>
    </div>
</div>
<!-- page title area end -->

<div class="main-content-inner">
    <div class="row">
        <div class="col-12 mt-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">{{ __('Investor Full Details') }}</h4>
                    <table class="table table-bordered mt-3">
                        <tbody>
                            <tr>
                                <th>Investor ID</th>
                                <td>{{ $investor->referral_id ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Name</th>
                                <td>
                                    {{ trim(($investor->first_name ?? '') . ' ' . ($investor->middle_name ?? '') . ' ' . ($investor->last_name ?? '')) ?: '—' }}
                                </td>
                            </tr>
                            <tr>
                                <th>Father Name</th>
                                <td>{{ $investor->father_name ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Mobile</th>
                                <td>{{ $investor->mobile ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Email</th>
                                <td>{{ $investor->email ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Address</th>
                                <td>{{ $investor->address ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Country</th>
                                <td>{{ optional($investor->country)->name ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>State</th>
                                <td>{{ optional($investor->state)->name ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>City</th>
                                <td>{{ $investor->city ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Company Name</th>
                                <td>{{ $investor->company_name ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>GST</th>
                                <td>{{ $investor->company_gst ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Education</th>
                                <td>{{ $investor->education_qualification ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Nominee</th>
                                <td>
                                    {{ $investor->nominee_name ?? '—' }}
                                    @if(!empty($investor->nominee_relationship))
                                        ({{ $investor->nominee_relationship }})
                                    @endif
                                    @if(!empty($investor->nominee_contact))
                                        - {{ $investor->nominee_contact }}
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>Bank Details</th>
                                <td>
                                    @if($investor->bank_name || $investor->account_number)
                                        {{ $investor->bank_name ?? '' }} - {{ $investor->bank_branch ?? '' }}<br>
                                        A/C: {{ $investor->account_number ?? '' }}<br>
                                        IFSC: {{ $investor->ifsc_code ?? '' }}<br>
                                        Type: {{ $investor->account_type ?? '' }}
                                    @else
                                        —
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>PAN</th>
                                <td>{{ $investor->pan ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Aadhaar</th>
                                <td>{{ $investor->aadhar_number ?? '—' }}</td>
                            </tr>
                            <tr>
                                <th>Added By</th>
                                <td>
                                    Name: {{ $investor->added_by_name ?? '—' }} <br>
                                    Email: {{ $investor->added_by_email ?? '—' }} <br>
                                    Personal ID: {{ $investor->added_by_personal_id ?? '—' }}
                                </td>
                            </tr>
                            <tr>
                                <th>Status</th>
                                <td>
                                    @if ($investor->status === 'Unverified')
                                        <span class="badge bg-warning">Unverified</span>
                                    @else
                                        <span class="badge bg-success">Verified</span>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>KYC Status</th>
                                <td>
                                    @if ($investor->kyc_status === 'KYC pending')
                                        <span class="badge bg-warning">KYC pending</span>
                                    @else
                                        <span class="badge bg-success">KYC updated</span>
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>

                    <a href="{{ route('admin.investorsrequest.index') }}" class="btn btn-secondary mt-3">Back</a>

                    @if ($investor->status === 'Unverified')
                        <a href="{{ route('admin.investorsrequest.approve', $investor->id) }}"
                           class="btn btn-success mt-3"
                           onclick="return confirm('Are you sure you want to Verify this investor?')">
                           Approve
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
