<?php

declare(strict_types=1);

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Models\Investment;
use App\Models\Admin;
use App\Models\Project;
use Illuminate\Http\Request;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Storage;

class InvestmentController extends Controller
{
    public function index()
    {
        $investments = Investment::all();
        return view('backend.pages.investments.index', compact('investments'));
    }

    public function create()
    {
        $investors = Admin::wherehas('roles',function($q){ $q->where('name','investor');})->get();
        $projects = Project::all();
        return view('backend.pages.investments.create', compact('investors', 'projects'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'investor_id' => 'required|exists:admins,id',
            'project_id' => 'required|exists:projects,id',
            'amount_invested' => 'required|numeric',
            'share_price' => 'required|numeric',
            'number_of_share' => 'required|numeric',
            // 'share_certificate' => 'required|file|mimes:pdf',
            'share_certificate' => 'file|mimes:pdf',
            
            'transaction_number' => 'required|string',
            'transaction_date' => 'required|date',
        ]);
			$share_certificate="";
		
			 if ($request->hasFile('share_certificate')) {
			$file = $request->file('share_certificate');
			$filename = time() . '_certificate.' . $file->getClientOriginalExtension();
			$file->move(public_path('certificates'), $filename);
			$share_certificate = 'certificates/' . $filename;
		}
			


        Investment::create([
            'investor_id' => $request->investor_id,
            'project_id' => $request->project_id,
            'amount_invested' => $request->amount_invested,
            'share_price' => $request->share_price,
            'number_of_share' => $request->number_of_share,
            'share_certificate' => $share_certificate,
            'transaction_number' => $request->transaction_number,
            'transaction_date' => $request->transaction_date,
        ]);

        return redirect()->route('admin.investments.index')->with('success', 'Investment created successfully!');
    }

    public function edit(Investment $investment)
    {
         $investors = Admin::wherehas('roles',function($q){ $q->where('name','investor');})->get();
        $projects = Project::all();
        return view('backend.pages.investments.edit', compact('investment', 'investors', 'projects'));
    }

    public function update(Request $request, Investment $investment)
    {
        $request->validate([
            'investor_id' => 'required|exists:admins,id',
            'project_id' => 'required|exists:projects,id',
            'amount_invested' => 'required|numeric',
            'number_of_share' => 'required|numeric',
            'share_price' => 'required|numeric', 
            'share_certificate' => 'nullable|file|mimes:pdf',
            'transaction_number' => 'required|string',
            'transaction_date' => 'required|date',
        ]);

       if ($request->hasFile('share_certificate')) {
			$file = $request->file('share_certificate');
			$filename = time() . '_certificate.' . $file->getClientOriginalExtension();
			$file->move(public_path('certificates'), $filename);
			$investment->share_certificate = 'certificates/' . $filename;
		}
		


        $investment->update([
            'investor_id' => $request->investor_id,
            'project_id' => $request->project_id,
            'amount_invested' => $request->amount_invested,
            'share_price' => $request->share_price,
            'number_of_share' => $request->number_of_share,
            'transaction_number' => $request->transaction_number,
            'transaction_date' => $request->transaction_date,
        ]);

        return redirect()->route('admin.investments.index')->with('success', 'Investment updated successfully!');
    }

    public function destroy(Investment $investment)
    {
        /* Storage::delete($investment->share_certificate);
        Storage::delete($investment->term_condition); */
        $investment->delete();

        return redirect()->route('admin.investments.index')->with('success', 'Investment deleted successfully!');
    }
}
