<?php

declare(strict_types=1);

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\InvestorRecord;
use App\Models\Admin;
use App\Models\Country;
use App\Models\State;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Spatie\Permission\Models\Role;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Illuminate\Support\Facades\Crypt;

class InvestorRecordController extends Controller
{
    /**
     * Show listing of investor requests
     */
	 public function approveInvestor($encryptedId)
	{
		$loginUrl = 'https://assatz-investors-dashboard.com/pages/other-pages/login';

		try {
			$id = Crypt::decryptString($encryptedId);
		} catch (\Exception $e) {
			return redirect($loginUrl)->with('error', 'Invalid or expired link.');
		}

		$investor2 = InvestorRecord::find($id);
		if (!$investor2) {
			return redirect($loginUrl)->with('error', 'Investor not found.');
		}
	if ($investor2->status === 'Verified') {
        return view('investorAccountAlreadyApproved', compact('loginUrl','investor2'));
    }
				$generateReferralId = $this->generateInvestorReferralId();
				// Create new Admin entry
				$admin = new Admin();
				$admin->title = $investor2->title;
				$admin->username = $investor2->username;
				$admin->first_name = $investor2->first_name;
				$admin->middle_name = $investor2->middle_name;
				$admin->last_name = $investor2->last_name;
				$admin->father_name = $investor2->father_name;
				$admin->mobile = $investor2->mobile;
				$admin->whatsapp = $investor2->whatsapp;
				$admin->email = $investor2->email;
				$admin->address = $investor2->address;
				$admin->country_id = $investor2->country_id;
				$admin->state_id = $investor2->state_id;
				$admin->city = $investor2->city;
				$admin->pincode = $investor2->pincode;
				$admin->company_name = $investor2->company_name;
				$admin->company_gst = $investor2->company_gst;
				$admin->education_qualification = $investor2->education_qualification;
				$admin->my_referral_id = $investor2->added_by_personal_id;
				$admin->referral_id = $generateReferralId;

				// Nominee
				$admin->nominee_name = $investor2->nominee_name;
				$admin->nominee_relationship = $investor2->nominee_relationship;
				$admin->nominee_contact = $investor2->nominee_contact;

				// Bank details
				$admin->bank_name = $investor2->bank_name;
				//$admin->bank_branch = $investor2->bank_branch;
				$admin->account_number = $investor2->account_number;
				$admin->ifsc_code = $investor2->ifsc_code;
				$admin->account_type = $investor2->account_type;
				$admin->pan = $investor2->pan;
				$admin->aadhar_number = $investor2->aadhar_number;

				// Password
				$admin->password = $investor2->password; // already hashed
				$admin->name = $investor2->name;

			   // $admin->status = 'Verified';
				$admin->save();

				// Assign "investor" role
				$admin->assignRole('investor');

				// Update investor record status
				$investor2->status = 'Verified';
				$investor2->save(); 

		return view('investorAccountSuccess', compact('loginUrl','investor2'));
	}
	public function index(Request $request)
{
    if ($request->ajax()) {
        $investors = InvestorRecord::query();

        return DataTables::of($investors)
            ->addColumn('actions', function ($row) {
                $btns = '<a href="'.route('admin.investorsrequest.show', $row->id).'" 
                            class="btn btn-sm btn-info me-1">View</a><a href="'.route('admin.investorsrequest.edit', $row->id).'" 
                            class="btn btn-sm btn-success me-1">Edit</a>';

                if ($row->status === 'Unverified') { 
                    $btns .= '<a href="'.route('admin.investorsrequest.approve', $row->id).'" 
                                class="btn btn-sm btn-success me-1"
                                onclick="return confirm(\'Are you sure you want to Verify this investor?\')">
                                Approve
                              </a>';
                } else {
                    $btns .= '';
                }

                // delete button with confirmation
				if ($row->status === 'Unverified') { 
                $btns .= '<form action="'.route('admin.investorsrequest.destroy', $row->id).'" 
                                method="POST" style="display:inline;">
                            '.csrf_field().method_field("DELETE").'
                            <button type="submit" 
                                class="btn btn-sm btn-danger"
                                onclick="return confirm(\'Are you sure you want to delete this investor?\')">
                                Delete
                            </button>
                        </form>';
				}
                return $btns;
            })
            ->editColumn('status', function ($row) {
                return $row->status === 'Unverified' 
                    ? '<span class="badge bg-warning">Unverified</span>'
                    : '<span class="badge bg-success">Verified</span>';
            })
			->editColumn('kyc_status', function ($row) {
                return $row->kyc_status === 'KYC pending' 
                    ? '<span class="badge bg-warning">KYC pending</span>'
                    : '<span class="badge bg-success">KYC updated</span>';
            })
            ->rawColumns(['actions','status','kyc_status'])
            ->make(true);
    }

    return view('backend.pages.investors.index');
}



	public function show($id)
	{
		$investor = InvestorRecord::findOrFail($id);
		return view('backend.pages.investors.show', compact('investor'));
	}
	public function edit(int $id): Renderable
    {
        $this->checkAuthorization(auth()->user(), ['investor.edit']);

        $admin = InvestorRecord::findOrFail($id);
        $countries = Country::all();
        $roles = Role::all();
        $states = State::all();
        return view('backend.pages.investors.edit', compact('admin', 'countries', 'roles', 'states'));
    }

    public function update(Request $request, int $id): RedirectResponse
    {
        $this->checkAuthorization(auth()->user(), ['investor.edit']);

        $admin = InvestorRecord::findOrFail($id);
       // $admin->username = $request->username; 
        $admin->title = $request->title; 
        $admin->first_name = $request->first_name; 
        $admin->middle_name = $request->middle_name; 
        $admin->last_name = $request->last_name; 
        $admin->father_name = $request->father_name; 
        $admin->mobile = $request->mobile;
        $admin->email = $request->email;
        $admin->whatsapp = $request->whatsapp; 
        $admin->address = $request->address; 
        $admin->country_id = $request->country; 
        $admin->state_id = $request->state; 
        $admin->city = $request->city; 
        $admin->pincode = $request->pincode; 
        //$admin->years_of_exp = $request->years_of_exp; 
        $admin->company_name = $request->company_name; 
        $admin->company_gst = $request->company_gst; 
        $admin->education_qualification = $request->education_qualification; 
        $admin->added_by_personal_id = $request->added_by_personal_id; 

        // Update nominee details
        $admin->nominee_name = $request->nominee_name;
        $admin->nominee_relationship = $request->nominee_relationship;
        $admin->nominee_contact = $request->nominee_contact;

        // Update bank details
        $admin->bank_name = $request->bank_name;
        $admin->account_number = $request->account_number;
        $admin->ifsc_code = $request->ifsc_code;
        $admin->account_type = $request->account_type;
		$admin->pan = $request->pan; 
		$admin->aadhar_number = $request->aadhar_number; // New field
        $admin->name = trim("{$request->first_name} {$request->middle_name} {$request->last_name}");
        if ($request->password) {
            $admin->password = Hash::make($request->password);
        }
        
        $admin->save();

        

        session()->flash('success', 'investor Request has been updated.');
        return back();
    }

    /** 
     * Approve investor and move data into admins table
     */
    public function approve(int $id): RedirectResponse
    {
        $investor = InvestorRecord::findOrFail($id);

        if ($investor->status === 'Verified') {
            return redirect()->back()->with('error', 'Investor already Verified.');
        }
		// Generate referral ID
		$generateReferralId = $this->generateInvestorReferralId();
        // Create new Admin entry
        $admin = new Admin();
        $admin->title = $investor->title;
        $admin->username = $investor->username;
        $admin->first_name = $investor->first_name;
        $admin->middle_name = $investor->middle_name;
        $admin->last_name = $investor->last_name;
        $admin->father_name = $investor->father_name;
        $admin->mobile = $investor->mobile;
        $admin->whatsapp = $investor->whatsapp;
        $admin->email = $investor->email;
        $admin->address = $investor->address;
        $admin->country_id = $investor->country_id;
        $admin->state_id = $investor->state_id;
        $admin->city = $investor->city;
        $admin->pincode = $investor->pincode;
        $admin->company_name = $investor->company_name;
        $admin->company_gst = $investor->company_gst;
        $admin->education_qualification = $investor->education_qualification;
        $admin->my_referral_id = $investor->added_by_personal_id;
        $admin->referral_id = $generateReferralId;

        // Nominee
        $admin->nominee_name = $investor->nominee_name;
        $admin->nominee_relationship = $investor->nominee_relationship;
        $admin->nominee_contact = $investor->nominee_contact;

        // Bank details
        $admin->bank_name = $investor->bank_name;
        //$admin->bank_branch = $investor->bank_branch;
        $admin->account_number = $investor->account_number;
        $admin->ifsc_code = $investor->ifsc_code;
        $admin->account_type = $investor->account_type;
        $admin->pan = $investor->pan;
        $admin->aadhar_number = $investor->aadhar_number;

        // Password
        $admin->password = $investor->password; // already hashed
        $admin->name = $investor->name;

       // $admin->status = 'Verified';
        $admin->save();

        // Assign "investor" role
        $admin->assignRole('investor');

        // Update investor record status
        $investor->status = 'Verified';
        $investor->save();
		
		

        return redirect()->back()->with('success', 'Investor has been Verified and moved to All Investors list.');
    }
	
	private function sendMail($to, $subject, $body)
    {
        try {
            $host = "smtpout.secureserver.net";
            $uName = "noreply@gio-realty.com";
            $pass = "TronicS123#";

            $mail = new PHPMailer(true);
            $mail->isSMTP();
            $mail->Host = $host;
            $mail->SMTPAuth = true;
            $mail->Username = $uName;
            $mail->Password = $pass;
            $mail->SMTPSecure = 'ssl';
            $mail->Port = 465;

            $mail->SMTPOptions = [
                'ssl' => [
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true,
                ]
            ];

            $mail->setFrom('noreply@gio-realty.com', 'Gio Realty');
            $mail->addAddress($to);

            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body    = $body;

            if (!$mail->send()) {
                return ['success' => false, 'message' => 'Mail not sent: ' . $mail->ErrorInfo];
            } else {
                return ['success' => true, 'message' => 'Mail sent successfully!'];
            }
        } catch (Exception $e) {
            return ['success' => false, 'message' => 'Mail error: ' . $e->getMessage()];
        }
    }
	
	 protected function generateInvestorReferralId()
	{
		$prefix = 'ASSATZ';
		// Get the last referral ID from the Admin table
		$lastReferral = Admin::where('referral_id', 'LIKE', "{$prefix}%")->whereHas('roles',function($q){ $q->where('name','investor');})->orderBy('referral_id', 'desc')->first();

		// Extract the numeric part and increment it
		if (!empty($lastReferral->referral_id)) {
			// Get the numeric part after the prefix (e.g., "GIOCP" or "FR")
			$lastId = intval(substr($lastReferral->referral_id, strlen($prefix))); 
			// Increment the ID and pad with zeros to ensure 5 digits
			$newId = str_pad((string)($lastId + 1), 4, '0', STR_PAD_LEFT); 
		} else {
			// If no referral ID exists, start from 00001
			$newId = '1001';
		}

		// Return the new Referral ID with the prefix
		return $prefix . $newId;
	}

	
	public function destroy($id)
	{
		$investor = InvestorRecord::findOrFail($id);
		$investor->delete();

		return redirect()->route('admin.investorsrequest.index')
			->with('success', 'Investor record deleted successfully.');
	}


}
