<?php

declare(strict_types=1);

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Models\Investment;
use App\Models\Projectshareprice;
use App\Models\Admin;
use App\Models\Project;
use Illuminate\Http\Request;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Storage;

class ProjectsharepriceController extends Controller
{
    public function index()
    {
        $projectshareprice = Projectshareprice::all();
        return view('backend.pages.projectshareprice.index', compact('projectshareprice'));
    }

    public function create()
    {
       
        $projects = Project::all();
        return view('backend.pages.projectshareprice.create', compact( 'projects'));
    }

    public function store(Request $request)
    {
        $request->validate([
            
            'project_id' => 'required|exists:projects,id',
            'share_price' => 'required|numeric',
            'transaction_date' => 'required|date',
        ]);

        Projectshareprice::create([
            'project_id' => $request->project_id,
            'share_price' => $request->share_price,
            'transaction_date' => $request->transaction_date,
        ]);

        return redirect()->route('admin.projectshareprice.index')->with('success', 'Projectshareprice created successfully!');
    }

    public function edit(Projectshareprice $projectshareprice)
    {
         $projects = Project::all();
        return view('backend.pages.projectshareprice.edit', compact('projectshareprice', 'projects'));
    }

    public function update(Request $request, Projectshareprice $projectshareprice)
    {
        $request->validate([
           
            'project_id' => 'required|exists:projects,id',
            'share_price' => 'required|numeric', 
            'transaction_date' => 'required|date',
        ]);

      
        $projectshareprice->update([
            'project_id' => $request->project_id,
           'share_price' => $request->share_price,
            'transaction_date' => $request->transaction_date,
        ]);

        return redirect()->route('admin.projectshareprice.index')->with('success', 'Projectshareprice updated successfully!');
    }

    public function destroy(Projectshareprice $projectshareprice)
    {
        /* Storage::delete($projectshareprice->share_certificate);
        Storage::delete($projectshareprice->term_condition); */
        $projectshareprice->delete();

        return redirect()->route('admin.projectshareprice.index')->with('success', 'Projectshareprice deleted successfully!');
    }
}
