@extends('backend.layouts.master')

@section('title', 'Edit Project - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Edit Project</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ route('admin.projects.update', $project->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf @method('PUT')
                        
                        <div class="form-group">
                            <label>Existing Image</label><br>
                            @if ($project->image)
                                <img src="{{ asset($project->image) }}" alt="Project Image" class="img-thumbnail" width="100px">
                            @else
                                <p>No image uploaded</p>
                            @endif
                        </div>

                        <div class="form-group">
                            <label>Change Image</label>
                            <input type="file" name="image" class="form-control-file">
                        </div>

                        <div class="form-group">
                            <label>Project Name<span style="color:red;">*</span></label>
                            <input type="text" class="form-control" name="name" value="{{ $project->name }}" required>
                        </div>

                        <div class="form-group">
                            <label>Description</label>
                            <textarea class="form-control" name="description">{{ $project->description }}</textarea>
                        </div>

                        {{-- <div class="form-group">
                            <label>IRR</label>
                            <input type="text" class="form-control" name="target_irr" value="{{ $project->target_irr }}">
                        </div>
						<div class="form-group">
                            <label>ROI</label>
                            <input type="text" class="form-control" name="roi" value="{{ $project->roi }}">
                        </div>--}}

                        <div class="form-group">
                            <label>Asset Value</label>
                            <input type="text" class="form-control" name="asset_value" value="{{ $project->asset_value }}">
                        </div>

                        <div class="form-group">
                            <label>Asset Type</label>
                            <input type="text" class="form-control" name="asset_type" value="{{ $project->asset_type }}">
                        </div>

                        <div class="form-group">
                            <label>Minimum Investment</label>
                            <input type="text" class="form-control" name="minimum_investment" value="{{ $project->minimum_investment }}">
                        </div>

                        <div class="form-group">
                            <label>Status</label>
                            <select class="form-control" name="status">
                                <option value="Active" {{ $project->status == 'Active' ? 'selected' : '' }}>Active</option>
                                <option value="Inactive" {{ $project->status == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                            </select>
                        </div>
						 <div class="form-group">
                            <label>Upload Terms & Conditions (PDF)</label>
                            <input type="file" name="term_condition" class="form-control-file" accept=".pdf">
                            @if($project->term_condition)
                                <p>Current file: <a href="{{ asset($project->term_condition) }}" target="_blank" class="btn btn-sm btn-primary">View Terms 📄</a></p>
                            @endif
                        </div>
						<div class="form-group">
                            <label>Upload Balance Sheet (PDF)</label>
                            <input type="file" name="balance_sheet" class="form-control-file" accept=".pdf">
                            @if($project->balance_sheet)
                                <p>Current file: <a href="{{ asset($project->balance_sheet) }}" target="_blank" class="btn btn-sm btn-primary">View Balance Sheet 📄</a></p>
                            @endif
                        </div>
						<div class="form-group">
                            <label>Launch Status</label>
                            <select class="form-control" name="launching_soon">
                                <option value="1" {{ $project->launching_soon == '1' ? 'selected' : '' }}>Launched</option>
                                <option value="0" {{ $project->launching_soon == '0' ? 'selected' : '' }}>Launching Soon</option>
                            </select>
                        </div>
                        

                        <hr>
                        <h5>Project Progress</h5>
                        <div id="progress-section">
                            @foreach ($project->progressImages as $index => $progress)
                                <div class="progress-group">
                                    <input type="hidden" name="progress_ids[{{ $index }}]" value="{{ $progress->id }}">
                                    <div class="form-group">
                                        <label>Progress Date<span style="color:red;">*</span></label>
                                        <input type="date" name="progress_dates[{{ $index }}]" class="form-control" value="{{ $progress->date }}" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Progress <span style="color:red;">*</span></label>
                                        <input type="text" name="progress_percentages[{{ $index }}]" class="form-control" value="{{ $progress->progress_percentage }}" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Existing Images</label><br>
                                        @foreach ($progress->images as $imageIndex => $image)
                                            <img src="{{ asset($image->image) }}" alt="Progress Image" class="img-thumbnail" width="100px"><a style="font-size: 16px; color: #e71515; background: #e1dede; padding: 0px 5px;" 
   href="{{ url('admin/remove/progress/image') }}/{{ $image->id }}" 
   onclick="return confirm('Are you sure you want to delete this image?');">
   <i class="fa fa-close"></i>
</a>

                                             <input type="text" name="progress_titles[{{ $index }}][{{ $imageIndex }}]" class="form-control mt-2" value="{{ old("progress_titles.$index.$imageIndex", $image->title) }}" placeholder="Enter title for image">
											 
											 
                                        @endforeach
                                    </div>
                                    <div class="form-group">
                                        <label>Upload More Images<span style="color:red;">*</span></label>
                                        <input type="file" name="progress_images[{{ $index }}][]" class="form-control-file" multiple >
                                    </div>
                                    <button type="button" class="btn btn-danger remove-progress" data-id="{{ $progress->id }}">Remove</button>
                                    <hr>
                                </div>
                            @endforeach
                        </div>
                        <button type="button" id="add-progress" class="btn btn-success">Add More Progress</button>
                        <br><br>
						
						<h5>Video Progress</h5>

						<div id="video-progress-section">
						@if(count($project->progressVideos) > 0)
							
							@foreach($project->progressVideos as $index => $video)
								<div class="video-progress-group">
									<input type="hidden" name="video_ids[{{ $index }}]" value="{{ $video->id }}">
									<div class="form-group">
										<label>Video Title</label>
										<input type="text" name="video_titles[{{ $index }}]" class="form-control" value="{{ $video->title }}" placeholder="Enter video title">
									</div>
									<div class="form-group">
										<label>Google Drive Video Link</label>
										<input type="url" name="video_links[{{ $index }}]" class="form-control" value="{{ $video->link }}" placeholder="Paste Google Drive video link">
									</div>
									{{--<button type="button" class="btn btn-danger remove-video-progress" data-id="{{ $video->id }}">Remove</button>--}}
									<hr>
								</div>
							@endforeach
							@else
								
							<div class="video-progress-group">
								<div class="form-group">
									<label>Video Title</label>
									<input type="text" name="video_titles[0]" class="form-control" placeholder="Enter video title">
								</div>
								<div class="form-group">
									<label>Google Drive Video Link</label>
									<input type="url" name="video_links[0]" class="form-control" placeholder="Paste Google Drive video link">
								</div>
								
								<hr>
							</div>
							@endif
						</div>

						{{--<button type="button" id="add-video-progress" class="btn btn-success">Add More Videos</button>
						<br><br>--}}

                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="{{ route('admin.projects.index') }}" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
	let videoIndex = {{ count($project->progressVideos) }};

	document.getElementById('add-video-progress').addEventListener('click', function () {
		let section = document.getElementById('video-progress-section');
		let newVideoGroup = `
			<div class="video-progress-group">
				<div class="form-group">
					<label>Video Title</label>
					<input type="text" name="video_titles[${videoIndex}]" class="form-control" placeholder="Enter video title">
				</div>
				<div class="form-group">
					<label>Google Drive Video Link</label>
					<input type="url" name="video_links[${videoIndex}]" class="form-control" placeholder="Paste Google Drive video link">
				</div>
				<button type="button" class="btn btn-danger remove-video-progress">Remove</button>
				<hr>
			</div>
		`;
		section.insertAdjacentHTML('beforeend', newVideoGroup);
		videoIndex++;
	});

	document.addEventListener('click', function (event) {
		if (event.target.classList.contains('remove-video-progress')) {
			let group = event.target.closest('.video-progress-group');
			let videoId = event.target.getAttribute('data-id');
			if (videoId) {
				// Send DELETE request to backend to remove from DB
				fetch(`{{ url('/admin/remove/progress/video') }}/${videoId}`, {
					method: 'DELETE',
					headers: {
						'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
					}
				}).then(response => {
					if (response.ok) {
						group.remove();
					}
				}).catch(error => {
					console.error('Error:', error);
				});
			} else {
				group.remove();
			}
		}
	});
</script>

<script>
    let progressIndex = {{ count($project->progressImages) }};
    document.getElementById('add-progress').addEventListener('click', function () {
        let progressSection = document.getElementById('progress-section');
        let newProgress = `
            <div class="progress-group">
                <div class="form-group">
                    <label>Progress Date<span style="color:red;">*</span></label>
                    <input type="date" name="progress_dates[${progressIndex}]" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Progress <span style="color:red;">*</span></label>
                    <input type="text" name="progress_percentages[${progressIndex}]" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Upload Progress Images<span style="color:red;">*</span></label>
                    <input type="file" name="progress_images[${progressIndex}][]" multiple class="form-control-file" accept="image/*" required>
                </div>
                <button type="button" class="btn btn-danger remove-progress">Remove</button>
                <hr>
            </div>
        `;
        progressSection.insertAdjacentHTML('beforeend', newProgress);
        progressIndex++;
    });	
        document.addEventListener('click', function (event) {
        if (event.target.classList.contains('remove-progress')) {
            let progressItem = event.target.closest('.progress-group');
            let progressId = event.target.getAttribute('data-id');  // Get the existing progress ID

            // If there's a progressId, trigger the DELETE request
            if (progressId) {
                fetch(`{{url('/')}}/admin/project-progress/${progressId}/delete`, {
                    method: 'DELETE',  // Ensure you're using the DELETE method
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    }
                }).then(response => {
                    if (response.ok) {
                        progressItem.remove();  // Remove from DOM after success
                    }
                }).catch(error => {
                    console.error('Error:', error);
                });
            } else {
                // If it's a dynamically added item without a progressId, just remove it from DOM
                progressItem.remove();
            }
        }
    });
    document.addEventListener('change', function (event) {
        if (event.target.matches('input[type="file"][name^="progress_images"]')) {
            let fileInput = event.target;
            let progressGroup = fileInput.closest('.progress-group');
            let progressTitlesDiv = progressGroup.querySelector(`[id^="progress-titles-"]`);
            progressTitlesDiv.innerHTML = '<label>Image Titles</label>';
            Array.from(fileInput.files).forEach((file, index) => {
                let titleInput = document.createElement('input');
                titleInput.type = 'text';
               titleInput.name = `${fileInput.name.replace('progress_images', 'progress_titles')}[${progressIndex}][${index}]`;
                titleInput.className = 'form-control';
                titleInput.placeholder = `Enter title for ${file.name}`;
                progressTitlesDiv.appendChild(titleInput);
            });
        }
    });
</script>

@endsection
