@extends('backend.layouts.master')

@section('title', 'Project Share Prices - Admin Panel')
 
@section('admin-content')
@section('styles')
    <!-- DataTables Bootstrap 4 CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css">
    <!-- DataTables Responsive CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap4.min.css">
@endsection

<style>
.btn-sm {
    padding: 4px 8px !important;
}
</style>

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">{{ __('Project Share Prices') }}</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li><span>{{ __('All Investments') }}</span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            @include('backend.layouts.partials.logout')
        </div>
    </div>
</div>
<!-- page title area end -->



<div class="main-content-inner">
    <div class="row">
         <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body">
				<h4 class="header-title float-left">{{ __('Project Share Price') }}</h4>
                    <p class="float-right mb-2">
                         <a href="{{ route('admin.projectshareprice.create') }}" class="btn btn-primary btn-sm">Add Project Share Price</a>
                    </p>
                    <table id="projectshareprice-table" class=" table table-bordered table-striped table-responsive">
                        <thead>
                            <tr>
							
                                <th>#</th>
                                <th>Project</th>
                                <th>Share Price</th>
                                <th>Transaction Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($projectshareprice as $key => $projectshareprice)
                                <tr> 
								<td>{{ $key+1 }}</td>
                                   
                                    <td>{{ $projectshareprice->project->name ?? "" }}</td>
									
                                    <td>{{ $projectshareprice->share_price ?? "" }}</td>
                                 <td>
  {{ $projectshareprice->transaction_date ? \Carbon\Carbon::parse($projectshareprice->transaction_date)->format('d-m-Y') : '' }}
</td>

                                  


                                    <td>
									  <div class="btn-group" role="group">
                                        <a href="{{ route('admin.projectshareprice.edit', $projectshareprice->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                        <form action="{{ route('admin.projectshareprice.destroy', $projectshareprice->id) }}" method="POST" style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                        </form>
                                    </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
			


                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
    <!-- jQuery (Ensure it is loaded before DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function () {
            $('#projectshareprice-table').DataTable({
                "responsive": true,
                "ordering": true,
                "paging": true,
                "searching": true
            });
			
			


        });
		
    </script>
	
@endsection
