@if (!in_array($admin->id, $visited))
    @php
        $visited[] = $admin->id; // Mark this admin as visited
        $currentLevel = isset($level) ? $level : 0; // Default level is 0 if not set
    @endphp

    <tr class="{{ $currentLevel % 2 === 0 ? 'bg-light' : '' }}" data-id="{{ $admin->id }}">
        <td style="padding-left: {{ $currentLevel * 20 }}px;">
            @if ($admin->children->isNotEmpty())
                <button class="toggle-children btn btn-success btn-sm text-white"> 
                    <i class="fa fa-plus"></i>
                </button> <!-- Plus sign for child levels -->
            @endif
        </td>
      
        <td>{{ $admin->referral_id }}</td>
        <td>{{ $admin->first_name }}</td>
        <td>{{ $admin->last_name }}</td>
        <td>{{ $admin->mobile }}</td>
        <td>{{ $admin->email }}</td>
        <td>{{ $admin->address }}</td>
        <td>
            @foreach ($admin->roles as $role)
                <span class="badge badge-info">
                    {{ $role->name }}
                </span>
            @endforeach
        </td>
        <td>
            @if (auth()->user()->can('admin.edit'))
                <a class="btn btn-sm btn-primary text-white" href="{{ route('admin.admins.edit', $admin->id) }}">
                    Edit
                </a>
            @endif

            @if (auth()->user()->can('admin.delete'))
                <button class="btn btn-sm btn-danger text-white" onclick="handleDelete({{ $admin->id }})">
                    Delete
                </button>
                <form id="delete-form-{{ $admin->id }}" action="{{ route('admin.admins.destroy', $admin->id) }}" method="POST" style="display: none;">
                    @method('DELETE')
                    @csrf
                </form>
            @endif
        </td>
    </tr>

    <!-- Include child rows if they exist -->
    @if ($admin->children->isNotEmpty())
        <tr class="child-row" data-parent-id="{{ $admin->id }}" style="display: none;">
            <td colspan="9">
                <table class="table table-bordered">
                    <thead>
                        <tr><td colspan="9"><strong>Children:</strong></td></tr>
                    </thead>
                    <tbody>
                        @foreach ($admin->children as $child)
                            @include('backend.pages.admins.partials.user-row', [
                                'admin' => $child, 
                                'visited' => $visited,
                                'level' => $currentLevel + 1 // Increment level for child nodes
                            ])
                        @endforeach
                    </tbody>
                </table>
            </td>
        </tr>
    @endif
@endif
