<?php $__env->startSection('title'); ?>
    <?php echo e(__('Franchise Partners - Admin Panel')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <!-- Start datatable css -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.18/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.3/css/responsive.jqueryui.min.css">
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left"><?php echo e(__('Franchise Partners')); ?></h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
                    <li><span><?php echo e(__('All Franchise Partners')); ?></span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            <?php echo $__env->make('backend.layouts.partials.logout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<!-- page title area end -->

<div class="main-content-inner">
    <div class="row">
        <!-- data table start -->
        <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title float-left"><?php echo e(__('Franchise Partners')); ?></h4>
                    <p class="float-right mb-2">
                        <?php if(auth()->user()->can('franchise.edit')): ?>
                            <a class="btn btn-primary text-white" href="<?php echo e(route('admin.franchise.create')); ?>">
                                <i class="fa fa-plus"></i> <?php echo e(__('Create New Franchise Partner')); ?>

                            </a>
                        <?php endif; ?>
                    </p>
                    <div class="clearfix"></div>
                    <div class="data-tables">
                        <?php echo $__env->make('backend.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <table id="admins-table" class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>Referral ID</th>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Mobile</th>
                                    <th>Email</th>
                                    <th>Address</th>
                                    <th>Roles</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo $__env->make('backend.pages.franchise.partials.user-row', [
                                        'admin' => $admin, 
                                        'visited' => [], 
                                        'level' => 0
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- data table end -->
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!-- Start datatable js -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.3/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.3/js/responsive.bootstrap.min.js"></script>

    <script>
  

    // Toggle child rows on parent row click (for the plus button)
    $('#admins-table').on('click', '.toggle-children', function() {
		//alert();
        var tr = $(this).closest('tr');
        var row = $(this).closest(tr);
        var parentId = tr.data('id');

        // Find the corresponding child row
        var childRow = $('tr.child-row[data-parent-id="' + parentId + '"]');

        if (childRow.is(':visible')) {
            // Hide the child row and change the plus sign to minus
            childRow.hide();
            $(this).text('+'); // Plus sign to expand
        } else {
            // Show the child row and change the plus sign to minus
            childRow.show();
            $(this).text('-'); // Minus sign to collapse
        }

        // Manually redraw the table to avoid _DT_CellIndex errors
        //table.responsive.recalc();
        //table.draw();
    
});




        // Format child row data
        function formatChildRow(data) {
            var admin = data[0]; // Assume first column contains the admin object
            var childrenHtml = `
                <table class="table table-bordered">
                    <tr><td colspan="9"><strong>Children:</strong></td></tr>
                    ${admin.children.map(child => `
                        <tr>
                            <td style="padding-left: 20px;">${child.name}</td>
                            <td>${child.level}</td>
                            <td>${child.referral_id}</td>
                            <td>${child.first_name}</td>
                            <td>${child.last_name}</td>
                            <td>${child.mobile}</td>
                            <td>${child.email}</td>
                            <td>${child.address}</td>
                            <td></td>
                        </tr>
                    `).join('')}
                </table>
            `;
            return childrenHtml;
        }

        // Handle delete action with confirmation modal
        function handleDelete(adminId) {
            if (confirm('Are you sure you want to delete this user?')) {
                document.getElementById(`delete-form-${adminId}`).submit();
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\wamp64\www\realestate.la\resources\views/backend/pages/franchise/index.blade.php ENDPATH**/ ?>