<?php $__env->startSection('title'); ?>
Channel Partner Create - Admin Panel
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .form-check-label {
        text-transform: capitalize;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">Channel Partner Create</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                    <li><a href="<?php echo e(route('admin.admins.index')); ?>">All Channel Partners</a></li>
                    <li><span>Create Channel Partner</span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            <?php echo $__env->make('backend.layouts.partials.logout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<!-- page title area end -->

<div class="main-content-inner">
    <div class="row">
        <!-- data table start -->
        <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Create New Channel Partner</h4>
                    <?php echo $__env->make('backend.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <form action="<?php echo e(route('admin.admins.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
						
						<!-- Personal Details -->
						<hr>
                        <h4 class="mt-4">Personal Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="title">Mr/Ms</label>
                                <select name="title" id="title" class="form-control" >
                                    <option value="Mr">Mr</option>
                                    <option value="Ms">Ms</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="first_name">First Name</label>
                                <input type="text" class="form-control" id="first_name" name="first_name" placeholder="Enter First Name"  value="<?php echo e(old('first_name')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="middle_name">Middle Name (Optional)</label>
                                <input type="text" class="form-control" id="middle_name" name="middle_name" placeholder="Enter Middle Name" value="<?php echo e(old('middle_name')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="last_name">Last Name</label>
                                <input type="text" class="form-control" id="last_name" name="last_name" placeholder="Enter Last Name"  value="<?php echo e(old('last_name')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="father_name">Father's Name</label>
                                <input type="text" class="form-control" id="father_name" name="father_name" placeholder="Enter Father's Name"  value="<?php echo e(old('father_name')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="mobile">Mobile No</label>
                                <input type="number" class="form-control" id="mobile" name="mobile" placeholder="Enter Mobile No"  value="<?php echo e(old('mobile')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="whatsapp">WhatsApp No (If different)</label>
                                <input type="number" class="form-control" id="whatsapp" name="whatsapp" placeholder="Enter WhatsApp No" value="<?php echo e(old('whatsapp')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="email">Email ID</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email ID"  value="<?php echo e(old('email')); ?>" required>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="address">Address</label>
                                <input type="text" class="form-control" id="address" name="address" placeholder="Enter Address"  value="<?php echo e(old('address')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="country">Country</label>
                                <select name="country" id="country" class="form-control" >
                                    <option value="">Select Country</option>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($country->country_id); ?>"><?php echo e($country->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="state">State</label>
                                <select name="state" id="state" class="form-control" >
                                    <option value="">Select State</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="city">City</label>
                                <input type="text" class="form-control" id="city" name="city" placeholder="Enter City"  value="<?php echo e(old('city')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="years_of_exp">Years of Experience in Real Estate</label>
                                <input type="number" class="form-control" id="years_of_exp" name="years_of_exp" placeholder="Enter Years of Experience"  value="<?php echo e(old('years_of_exp')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="company_name">Company Name (Optional)</label>
                                <input type="text" class="form-control" id="company_name" name="company_name" placeholder="Enter Company Name" value="<?php echo e(old('company_name')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="company_gst">Company GST (Optional)</label>
                                <input type="text" class="form-control" id="company_gst" name="company_gst" placeholder="Enter Company GST" value="<?php echo e(old('company_gst')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="education_qualification">Education Qualification</label>
                                <select name="education_qualification" id="education_qualification" class="form-control" >
                                    <option value="Masters">Masters</option>
                                    <option value="Graduate">Graduate</option>
                                    <option value="Diploma">Diploma</option>
                                    <option value="High School">High School</option>
                                </select>
                            </div>
                        </div>

						
						<div class="form-row">
							<div class="form-group col-md-6 col-sm-12">
								<label for="my_referral_id">My Referral ID </label>
								<input type="text" class="form-control" id="my_referral_id" name="my_referral_id" placeholder="Enter Referral ID" >
								<div id="admin-details" class="mt-2" style="display: none;"></div>
							</div>
						</div>
						<div class="form-row">
						<div class="form-group col-md-6 col-sm-12">
							<label for="aadhar_number">Aadhar Number</label>
							<input type="text" class="form-control" id="aadhar_number" name="aadhar_number" value="<?php echo e(old('aadhar_number','')); ?>" placeholder="Enter Aadhar Number">
						</div>
						<div class="form-group col-md-6 col-sm-12">
							<label for="pan">PAN Number</label>
							<input type="text" class="form-control" id="pan" name="pan" value="<?php echo e(old('pan', '')); ?>" placeholder="Enter PAN">
						</div>
						</div>
						  <div class="form-row">
                           
                            <div class="form-group col-md-12 col-sm-12">
                                <label for="username">Username</label>
                                <input type="text" class="form-control" id="username" name="username" placeholder="Enter Username" required value="<?php echo e(old('username')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="password">Password</label>
                                <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password" required>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="password_confirmation">Confirm Password</label>
                                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Confirm Password" required>
                            </div>
                        </div>
						<!-- Nominee Details -->
						<hr>
                        <h4 class="mt-4">Nominee Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_name">Nominee Name (Optional)</label>
                                <input type="text" class="form-control" id="nominee_name" name="nominee_name" placeholder="Enter Nominee Name" value="<?php echo e(old('nominee_name')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_relationship">Nominee Relationship (Optional)</label>
                                <input type="text" class="form-control" id="nominee_relationship" name="nominee_relationship" placeholder="Enter Relationship with Nominee" value="<?php echo e(old('nominee_relationship')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_contact">Nominee Contact No (Optional)</label>
                                <input type="text" class="form-control" id="nominee_contact" name="nominee_contact" placeholder="Enter Nominee Contact No" value="<?php echo e(old('nominee_contact')); ?>">
                            </div>
                        </div>
						  <!-- Nominee Details -->
						  <hr>
                        <h4 class="mt-4">Bank Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="bank_name">Bank Name </label>
                                <input type="text" class="form-control" id="bank_name" name="bank_name" placeholder="Enter Bank Name"  value="<?php echo e(old('bank_name')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="bank_branch">Bank Branch </label>
                                <input type="text" class="form-control" id="bank_branch" name="bank_branch" placeholder="Enter Bank Branch"  value="<?php echo e(old('bank_branch')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="account_number">Bank Account Number </label>
                                <input type="text" class="form-control" id="account_number" name="account_number" placeholder="Enter Bank Account Number"  value="<?php echo e(old('account_number')); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="bank_ifsc">Bank IFSC Code </label>
                                <input type="text" class="form-control" id="bank_ifsc" name="bank_ifsc" placeholder="Enter Bank IFSC Code"  value="<?php echo e(old('bank_ifsc')); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="account_type">Account Type </label>
                                <select name="account_type" id="account_type" class="form-control" >
                                    <option value="Savings">Savings</option>
                                    <option value="Current">Current</option>
                                    <option value="Salary">Salary</option>
                                </select>
                            </div>
                        </div>
 

                      
                        <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">Save</button>
                        <a href="<?php echo e(route('admin.admins.index')); ?>" class="btn btn-secondary mt-4 pr-4 pl-4">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
        <!-- data table end -->
        
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2();
    });

    $('#country').on('change', function() {
        var countryId = $(this).val();
        
        if (countryId) {
            $.ajax({
                url: '<?php echo e(url("getstates")); ?>', // Your route to get states
                type: 'GET',
                data: { country_id: countryId },
                success: function(data) {
                    $('#state').empty();
                    $('#state').append('<option value="">Select State</option>');
                    $.each(data, function(key, value) {
                        $('#state').append('<option value="' + value.state_id + '">' + value.name + '</option>');
                    });
                }
            });
        } else {
            $('#state').empty();
            $('#state').append('<option value="">Select State</option>');
        }
    });
	
	
	
</script>
<script>
    $(document).ready(function() {
        // Initialize select2 for other select elements
        $('.select2').select2();

        // Handle input for Referral ID
        $('#my_referral_id').on('input', function() {
            var referralId = $(this).val();
            if (referralId) {
                $.ajax({
                    url: '<?php echo e(url("getAdminDetails")); ?>', // Your route to fetch admin details
                    type: 'GET',
                    data: { referral_id: referralId },
                    success: function(data) {
                        // Display admin details
                        var detailsHtml = `
                            <strong>Referral Details:</strong><br>
                            Name: ${data.name}<br>
                            Email: ${data.email}<br>
                            <!-- Add more fields as needed -->
                        `;
                        $('#admin-details').html(detailsHtml).show();
                    },
                    error: function() {
                        // Handle error
                        $('#admin-details').html('<span class="text-danger">No data found with this Referral ID</span>').show();
                    }
                });
            } else {
                // Clear details if input is empty
                $('#admin-details').hide();
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\wamp64\www\realestate.la\resources\views/backend/pages/admins/create.blade.php ENDPATH**/ ?>