<?php if(!in_array($admin->id, $visited)): ?>
    <?php
        $visited[] = $admin->id; // Mark this admin as visited
        $currentLevel = isset($level) ? $level : 0; // Default level is 0 if not set
    ?>

    <tr class="<?php echo e($currentLevel % 2 === 0 ? 'bg-light' : ''); ?>" data-id="<?php echo e($admin->id); ?>">
        <td style="padding-left: <?php echo e($currentLevel * 20); ?>px;">
            <?php if($admin->children->isNotEmpty()): ?>
                <button class="toggle-children btn btn-success btn-sm text-white"> 
                    <i class="fa fa-plus"></i>
                </button> <!-- Plus sign for child levels -->
            <?php endif; ?>
        </td>
      
        <td><?php echo e($admin->referral_id); ?></td>
        <td><?php echo e($admin->first_name); ?></td>
        <td><?php echo e($admin->last_name); ?></td>
        <td><?php echo e($admin->mobile); ?></td>
        <td><?php echo e($admin->email); ?></td>
        <td><?php echo e($admin->address); ?></td>
        <td>
            <?php $__currentLoopData = $admin->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <span class="badge badge-info">
                    <?php echo e($role->name); ?>

                </span>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </td>
        <td>
            <?php if(auth()->user()->can('franchise.edit')): ?>
                <a class="btn btn-sm btn-primary text-white" href="<?php echo e(route('admin.franchise.edit', $admin->id)); ?>">
                    Edit
                </a>
            <?php endif; ?>

            <?php if(auth()->user()->can('franchise.delete')): ?>
                <button class="btn btn-sm btn-danger text-white" onclick="handleDelete(<?php echo e($admin->id); ?>)">
                    Delete
                </button>
                <form id="delete-form-<?php echo e($admin->id); ?>" action="<?php echo e(route('admin.franchise.destroy', $admin->id)); ?>" method="POST" style="display: none;">
                    <?php echo method_field('DELETE'); ?>
                    <?php echo csrf_field(); ?>
                </form>
            <?php endif; ?>
        </td>
    </tr>

    <!-- Include child rows if they exist -->
    <?php if($admin->children->isNotEmpty()): ?>
        <tr class="child-row" data-parent-id="<?php echo e($admin->id); ?>" style="display: none;">
            <td colspan="9">
                <table class="table table-bordered">
                    <thead>
                        <tr><td colspan="9"><strong>Children:</strong></td></tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $admin->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo $__env->make('backend.pages.franchise.partials.user-row', [
                                'admin' => $child, 
                                'visited' => $visited,
                                'level' => $currentLevel + 1 // Increment level for child nodes
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </td>
        </tr>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH F:\wamp64\www\realestate.la\resources\views/backend/pages/franchise/partials/user-row.blade.php ENDPATH**/ ?>