<?php $__env->startSection('title'); ?>
Franchise Partner Edit - Admin Panel
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .form-check-label {
        text-transform: capitalize;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-content'); ?>

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">Franchise Partner Edit</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                    <li><a href="<?php echo e(route('admin.admins.index')); ?>">All Franchise Partners</a></li>
                    <li><span>Edit Franchise Partner - <?php echo e($admin->name); ?></span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            <?php echo $__env->make('backend.layouts.partials.logout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<!-- page title area end -->

<div class="main-content-inner">
    <div class="row">
        <!-- data table start -->
        <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Edit Franchise Partner - <?php echo e($admin->name); ?></h4>
                    <?php echo $__env->make('backend.layouts.partials.messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <form action="<?php echo e(route('admin.admins.update', $admin->id)); ?>" method="POST">
                        <?php echo method_field('PUT'); ?>
                        <?php echo csrf_field(); ?>
						<hr>
                        <h4 class="mt-4">Personal Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="title">Mr/Ms</label>
                                <select name="title" id="title" class="form-control" >
                                    <option value="Mr" <?php echo e($admin->title === 'Mr' ? 'selected' : ''); ?>>Mr</option>
                                    <option value="Ms" <?php echo e($admin->title === 'Ms' ? 'selected' : ''); ?>>Ms</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="first_name">First Name</label>
                                <input type="text" class="form-control" id="first_name" name="first_name" placeholder="Enter First Name" value="<?php echo e($admin->first_name); ?>" >
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="middle_name">Middle Name (Optional)</label>
                                <input type="text" class="form-control" id="middle_name" name="middle_name" placeholder="Enter Middle Name" value="<?php echo e($admin->middle_name); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="last_name">Last Name</label>
                                <input type="text" class="form-control" id="last_name" name="last_name" placeholder="Enter Last Name" value="<?php echo e($admin->last_name); ?>" >
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="father_name">Father's Name</label>
                                <input type="text" class="form-control" id="father_name" name="father_name" placeholder="Enter Father's Name" value="<?php echo e($admin->father_name); ?>" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="mobile">Mobile No</label>
                                <input type="number" class="form-control" id="mobile" name="mobile" placeholder="Enter Mobile No" value="<?php echo e($admin->mobile); ?>" >
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="email">Email ID</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email ID" value="<?php echo e($admin->email); ?>" required>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="address">Address</label>
                                <input type="text" class="form-control" id="address" name="address" placeholder="Enter Address" value="<?php echo e($admin->address); ?>" >
                            </div>
                        </div>

                        <div class="form-row">
                           <div class="form-group col-md-6 col-sm-12">
                                <label for="country">Country</label>
                                <select name="country" id="country" class="form-control" >
                                    <option value="">Select Country</option>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($country->country_id); ?>" <?php echo e($admin->country_id === $country->country_id ? 'selected' : ''); ?>><?php echo e($country->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div> 
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="state">State</label>
                                <select name="state" id="state" class="form-control" >
                                    <option value="">Select State</option>
                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($state->state_id); ?>" <?php echo e($admin->state_id === $state->state_id ? 'selected' : ''); ?>><?php echo e($state->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="city">City</label>
                                <input type="text" class="form-control" id="city" name="city" placeholder="Enter City" value="<?php echo e($admin->city); ?>" >
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="years_of_exp">Years of Experience in Real Estate</label>
                                <input type="number" class="form-control" id="years_of_exp" name="years_of_exp" placeholder="Enter Years of Experience" value="<?php echo e($admin->years_of_exp); ?>" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="company_name">Company Name (Optional)</label>
                                <input type="text" class="form-control" id="company_name" name="company_name" placeholder="Enter Company Name" value="<?php echo e($admin->company_name); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="company_gst">Company GST (Optional)</label>
                                <input type="text" class="form-control" id="company_gst" name="company_gst" placeholder="Enter Company GST" value="<?php echo e($admin->company_gst); ?>">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="education_qualification">Education Qualification</label>
                                <select name="education_qualification" id="education_qualification" class="form-control" >
                                    <option value="Masters" <?php echo e($admin->education_qualification === 'Masters' ? 'selected' : ''); ?>>Masters</option>
                                    <option value="Graduate" <?php echo e($admin->education_qualification === 'Graduate' ? 'selected' : ''); ?>>Graduate</option>
                                    <option value="Diploma" <?php echo e($admin->education_qualification === 'Diploma' ? 'selected' : ''); ?>>Diploma</option>
                                    <option value="High School" <?php echo e($admin->education_qualification === 'High School' ? 'selected' : ''); ?>>High School</option>
                                </select>
                            </div>
                        </div>

                        <!-- My Referral ID -->
						
						<div class="form-row">
							<div class="form-group col-md-6 col-sm-12">
								<label for="my_referral_id">My Referral ID </label>
								<input type="text" class="form-control" id="my_referral_id" name="my_referral_id" placeholder="Enter Referral ID"  value="<?php echo e($admin->my_referral_id); ?>">
								<div id="admin-details" class="mt-2" style="display: none;"></div>
							</div>
						</div>

						<div class="form-row">
						<div class="form-group">
							<label for="aadhar_number">Aadhar Number</label>
							<input type="text" class="form-control" id="aadhar_number" name="aadhar_number" value="<?php echo e(old('aadhar_number', $admin->aadhar_number)); ?>" placeholder="Enter Aadhar Number">
						</div>
						<div class="form-group">
							<label for="pan">PAN Number</label>
							<input type="text" class="form-control" id="pan" name="pan" value="<?php echo e(old('pan', $admin->pan)); ?>" placeholder="Enter PAN">
						</div>
						</div>
						  <div class="form-row">
                            
                            <div class="form-group col-md-12 col-sm-12">
                                <label for="username">Username</label>
                                <input type="text" class="form-control" id="username" name="username" placeholder="Enter Username" required value="<?php echo e($admin->username); ?>">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="password">Password (Optional)</label>
                                <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password">
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="password_confirmation">Confirm Password (Optional)</label>
                                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Enter Password">
                            </div>
                        </div>
                        <!-- Nominee Details -->
						<hr>
                        <h4 class="mt-4">Nominee Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_name">Nominee Name </label>
                                <input type="text" class="form-control" id="nominee_name" name="nominee_name" placeholder="Enter Nominee Name" value="<?php echo e(old('nominee_name', $admin->nominee_name)); ?>" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_relationship">Nominee Relationship </label>
                                <input type="text" class="form-control" id="nominee_relationship" name="nominee_relationship" placeholder="Enter Nominee Relationship" value="<?php echo e(old('nominee_relationship', $admin->nominee_relationship)); ?>" >
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="nominee_contact">Nominee Contact No </label>
                                <input type="number" class="form-control" id="nominee_contact" name="nominee_contact" placeholder="Enter Nominee Contact No" value="<?php echo e(old('nominee_contact', $admin->nominee_contact)); ?>" >
                            </div>
                        </div>
<hr>
                        <!-- Bank Details -->
                        <h4 class="mt-4">Bank Details</h4>
						<hr>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="bank_name">Bank Name </label>
                                <input type="text" class="form-control" id="bank_name" name="bank_name" placeholder="Enter Bank Name" value="<?php echo e(old('bank_name', $admin->bank_name)); ?>" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="account_number">Account Number </label>
                                <input type="text" class="form-control" id="account_number" name="account_number" placeholder="Enter Account Number" value="<?php echo e(old('account_number', $admin->account_number)); ?>" >
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="ifsc_code">IFSC Code </label>
                                <input type="text" class="form-control" id="ifsc_code" name="ifsc_code" placeholder="Enter IFSC Code" value="<?php echo e(old('ifsc_code', $admin->ifsc_code)); ?>" >
                            </div>
                            <div class="form-group col-md-6 col-sm-12">
                                <label for="account_type">Account Type </label>
                                <select name="account_type" id="account_type" class="form-control" >
                                    <option value="Savings" <?php echo e($admin->account_type === 'Savings' ? 'selected' : ''); ?>>Savings</option>
                                    <option value="Current" <?php echo e($admin->account_type === 'Current' ? 'selected' : ''); ?>>Current</option>
                                    <option value="Salary" <?php echo e($admin->account_type === 'Salary' ? 'selected' : ''); ?>>Salary</option>
                                </select>
                            </div>
                        </div>

                      

                        <button type="submit" class="btn btn-primary mt-4 pr-4 pl-4">Save</button>
                        <a href="<?php echo e(route('admin.admins.index')); ?>" class="btn btn-secondary mt-4 pr-4 pl-4">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
        <!-- data table end -->
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-beta.1/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2();

        // Load states when country changes
        $('#country').on('change', function() {
            var countryId = $(this).val();
            
            if (countryId) {
                $.ajax({
                    url: '<?php echo e(url("getstates")); ?>', // Your route to get states
                    type: 'GET',
                    data: { country_id: countryId },
                    success: function(data) {
                        $('#state').empty();
                        $('#state').append('<option value="">Select State</option>');
                        $.each(data, function(key, value) {
                            $('#state').append('<option value="' + value.state_id + '">' + value.name + '</option>');
                        });

                        // Pre-select state if it exists in the fetched states
                        var currentStateId = '<?php echo e($admin->state_id); ?>';
                        if (currentStateId) {
                            $('#state').val(currentStateId).trigger('change');
                        }
                    }
                });
            } else {
                $('#state').empty();
                $('#state').append('<option value="">Select State</option>');
            }
        });

        // Trigger the change event on page load to set states correctly
        $('#country').trigger('change');
    });
</script>

<script>
    $(document).ready(function() {
        $('.select2').select2();

        // Load states when country changes
        $('#country').on('change', function() {
            // ... existing state loading code ...
        });

        // Trigger the change event on page load to set states correctly
        $('#country').trigger('change');

        // Handle input for Referral ID
        $('#my_referral_id').on('input', function() {
            var referralId = $(this).val();
            if (referralId) {
                $.ajax({
                    url: '<?php echo e(url("getAdminDetails")); ?>', // Your route to fetch admin details
                    type: 'GET',
                    data: { referral_id: referralId },
                    success: function(data) {
                        var detailsHtml = `
                            <strong>Referral Details:</strong><br>
                            Name: ${data.name}<br>
                            Email: ${data.email}<br>
                            <!-- Add more fields as necessary -->
                        `;
                        $('#admin-details').html(detailsHtml).show();
                    },
                    error: function() {
                        $('#admin-details').html('<span class="text-danger">No admin found with this Referral ID</span>').show();
                    }
                });
            } else {
                $('#admin-details').hide();
            }
        });

        // Trigger fetching of details for the existing Referral ID on page load
        $('#my_referral_id').trigger('input');
    });
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH F:\wamp64\www\realestate.la\resources\views/backend/pages/franchise/edit.blade.php ENDPATH**/ ?>