<?php

namespace App\Models; 

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
class Investment extends Model
{
    use HasFactory;

    protected $fillable = [ 
        'investor_id',
        'project_id',
        'terms_accepted',
        'amount_invested',
        'number_of_share',
        'share_price',
        'share_certificate',
        'balance_sheet',
        'term_condition',
        'transaction_number',
        'transaction_date',
    ];

    protected $appends = ['share_certificate_url', 'term_condition_url', 'balance_sheet_url'];

    public function investor()
    {
        return $this->belongsTo(Admin::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function getShareCertificateUrlAttribute()
    {
        return $this->share_certificate ? asset($this->share_certificate) : null;
    }

    public function getTermConditionUrlAttribute()
    {
        // Project table se term_condition ka URL fetch karega
        return $this->project && $this->project->term_condition ? asset($this->project->term_condition) : null;
    }

    public function getBalanceSheetUrlAttribute()
    {
        // Project table se balance_sheet ka URL fetch karega
        return $this->project && $this->project->balance_sheet ? asset($this->project->balance_sheet) : null;
    }
	 public function getTransactionDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
	public function getCreatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
	public function getUpdatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
}
 