<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles;
use Laravel\Sanctum\HasApiTokens;
use Carbon\Carbon;

class InvestorRecord extends Model
{
    use HasFactory, Notifiable, HasRoles, HasApiTokens;

    protected $table = 'investor_records';

    protected $fillable = [
        'referral_id',
        'title',
        'profile_picture',
        'username',
        'app_user',
        'first_name',
        'middle_name',
        'last_name',
        'father_name',
        'pincode',
        'mobile',
        'whatsapp',
        'email',
        'address',
        'state_id',
        'country_id',
        'city',
        'years_of_exp',
        'company_name',
        'company_pan_number',
        'company_gst',
        'education_qualification',
        'nominee_name',
        'nominee_relationship',
        'nominee_contact',
        'bank_name',
        'account_number',
        'ifsc_code',
        'account_type',
        'pan',
        'aadhar_number',
        'password',
        'added_by_name',
        'added_by_email',
        'added_by_personal_id',
        'status',
        'company_gst_certificate',
        'company_pan',
        'pan_card_doc',
        'aadhar_card_doc',
        'first_login',
        'bank_branch',
        'kyc_status',
    ];

    protected $hidden = ['password']; 

    protected $appends = [
        'profile_picture_url',
        'aadhar_card_doc_url',
        'pan_card_doc_url',
        'company_gst_certificate_url',
        'company_pan_doc_url'
    ];

    // Relations
    public function parent()
    {
        return $this->belongsTo(Admin::class, 'my_referral_id', 'referral_id');
    }

    public function children()
    {
        return $this->hasMany(Admin::class, 'referral_id', 'my_referral_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'country_id');
    }

    public function state()
    {
        return $this->belongsTo(State::class, 'state_id', 'state_id');
    }

    // Accessors for document URLs
    public function getProfilePictureUrlAttribute()
    {
        return $this->profile_picture ? asset($this->profile_picture) : null;
    }

    public function getAadharCardDocUrlAttribute()
    {
        return $this->aadhar_card_doc ? asset($this->aadhar_card_doc) : null;
    }

    public function getPanCardDocUrlAttribute()
    {
        return $this->pan_card_doc ? asset($this->pan_card_doc) : null;
    }

    public function getCompanyGstCertificateUrlAttribute()
    {
        return $this->company_gst_certificate ? asset($this->company_gst_certificate) : null;
    }

    public function getCompanyPanDocUrlAttribute()
    {
        return $this->company_pan ? asset($this->company_pan) : null;
    }

    // Date accessors
    public function getCreatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }

    public function getUpdatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }

    public function getTransactionDateAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
}
