<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use File;
use Carbon\Carbon;
class ProjectProgressImage extends Model
{
    protected $fillable = ['progress_id', 'image', 'title'];
 protected $appends = ['image_url'];

    // Relationship with Project
    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    // Append full URL for image
    public function getImageUrlAttribute()
    {
        if ($this->image) {
            // Check if the file exists using File facade
            $imagePath = public_path($this->image);
            return File::exists($imagePath) ? asset($this->image) : null;
        }

        return null;
    }
    public function progress()
    {
        return $this->belongsTo(ProjectProgress::class, 'progress_id');
    }
	public function getCreatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
	public function getUpdatedAtAttribute($value)
    {
        return $value ? Carbon::parse($value)->format('d-m-Y') : null;
    }
}


