<!-- sidebar menu area start -->
@php
    $usr = Auth::guard('admin')->user();
@endphp
<div class="sidebar-menu">
    <div class="sidebar-header d-flex justify-content-between">
        <div class="logo">
            <a href="{{ route('admin.dashboard') }}">
                <h5 class="text-white">Assatz</h5>
            </a>
        </div>
        <div class="closeSidebar cursor-pointer">
            <i class="fa fa-chevron-left text-white"></i>
        </div>
    </div>
    <div class="main-menu">
        <div class="menu-inner">
            <nav>
                <ul class="metismenu" id="menu">

                    @if ($usr->can('dashboard.view'))
                        <li class="active">
                            <a href="javascript:void(0)" aria-expanded="true"><i
                                    class="ti-dashboard"></i><span>Dashboard</span></a>
                            <ul class="collapse">
                                <li class="{{ Route::is('admin.dashboard') ? 'active' : '' }}"><a
                                        href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                            </ul>
                        </li>
                    @endif
 
                    @if (
                        $usr->can('investor.create') ||
                            $usr->can('investor.view') ||
                            $usr->can('investor.edit') ||
                            $usr->can('investor.delete'))
                        <li>
                            <a href="javascript:void(0)" aria-expanded="true"><i
                                    class="fa fa-user"></i><span>Investor</span></a>
                            <ul
                                class="collapse {{ Route::is('admin.admins.create') || Route::is('admin.admins.index') || Route::is('admin.admins.edit') || Route::is('admin.admins.show') ? 'in' : '' }}">
                                @if ($usr->can('investor.view'))
                                    <li
                                        class="{{ Route::is('admin.admins.index') || Route::is('admin.admins.edit') ? 'active' : '' }}">
                                        <a href="{{ route('admin.admins.index') }}">All Investors</a></li>
										<li
                                        class="{{ Route::is('admin.investorsrequest.index')  ? 'active' : '' }}">
                                        <a href="{{ route('admin.investorsrequest.index') }}">Investors Request List</a></li>
                                @endif
                                @if ($usr->can('investor.create'))
                                    <li class="{{ Route::is('admin.admins.create') ? 'active' : '' }}"><a
                                            href="{{ route('admin.admins.create') }}">Create Investor</a></li>
                                @endif
                            </ul>
                        </li>
                    @endif

                    @if (
                        $usr->can('project.create') ||
                            $usr->can('project.view') ||
                            $usr->can('project.edit') ||
                            $usr->can('project.delete'))
                        <li>
                            <a href="javascript:void(0)" aria-expanded="true"><i
                                    class="fa fa-user"></i><span>Projects</span></a>
                            <ul
                                class="collapse {{ Route::is('admin.projects.create') || Route::is('admin.projects.index') || Route::is('admin.projects.edit') || Route::is('admin.projects.show') ? 'in' : '' }}">
                                @if ($usr->can('project.view'))
                                    <li
                                        class="{{ Route::is('admin.projects.index') || Route::is('admin.projects.edit') ? 'active' : '' }}">
                                        <a href="{{ route('admin.projects.index') }}">All Projects</a></li>
                                @endif
                                @if ($usr->can('project.create'))
                                    <li class="{{ Route::is('admin.projects.create') ? 'active' : '' }}"><a
                                            href="{{ route('admin.projects.create') }}">Create Project</a></li>
                                @endif
                            </ul>
                        </li>
                    @endif

                    @if ($usr->can('investor.investment'))
                        <li>
                            <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-user"></i><span>Investor
                                    Investments</span></a>
                            <ul
                                class="collapse {{ Route::is('admin.investments.create') || Route::is('admin.investments.index') || Route::is('admin.investments.edit') || Route::is('admin.investments.show') ? 'in' : '' }}">
                                <li
                                    class="{{ Route::is('admin.investments.index') || Route::is('admin.investments.edit') ? 'active' : '' }}">
                                    <a href="{{ route('admin.investments.index') }}">All Investments</a></li>
                                <li class="{{ Route::is('admin.investments.create') ? 'active' : '' }}"><a
                                        href="{{ route('admin.investments.create') }}">Create Investment</a></li>
                            </ul>
                        </li>
						
						<li>
                            <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-user"></i><span>Project Share Price </span></a>
                            <ul
                                class="collapse {{ Route::is('admin.projectshareprice.create') || Route::is('admin.projectshareprice.index') || Route::is('admin.projectshareprice.edit') || Route::is('admin.projectshareprice.show') ? 'in' : '' }}">
                                <li
                                    class="{{ Route::is('admin.projectshareprice.index') || Route::is('admin.projectshareprice.edit') ? 'active' : '' }}">
                                    <a href="{{ route('admin.projectshareprice.index') }}">All Project Share Price List</a></li>
                                <li class="{{ Route::is('admin.projectshareprice.create') ? 'active' : '' }}"><a
                                        href="{{ route('admin.projectshareprice.create') }}">Create Project Share Price</a></li>
                            </ul>
                        </li>
                    @endif

                    {{-- @if ($usr->can('role.create') || $usr->can('role.view') || $usr->can('role.edit') || $usr->can('role.delete'))
                    <li>
                        <a href="javascript:void(0)" aria-expanded="true"><i class="fa fa-tasks"></i><span>Roles & Permissions</span></a>
                        <ul class="collapse {{ Route::is('admin.roles.create') || Route::is('admin.roles.index') || Route::is('admin.roles.edit') || Route::is('admin.roles.show') ? 'in' : '' }}">
                            @if ($usr->can('role.view'))
                                <li class="{{ Route::is('admin.roles.index') || Route::is('admin.roles.edit') ? 'active' : '' }}"><a href="{{ route('admin.roles.index') }}">All Roles</a></li>
                            @endif
                            @if ($usr->can('role.create'))
                                <li class="{{ Route::is('admin.roles.create') ? 'active' : '' }}"><a href="{{ route('admin.roles.create') }}">Create Role</a></li>
                            @endif
                        </ul>
                    </li>
                    @endif --}}


                </ul>
            </nav>
        </div>
    </div>
</div>
<!-- sidebar menu area end -->
