@extends('backend.layouts.master')

@section('title')
    {{ __('Investors - Admin Panel') }}
@endsection

@section('styles') 
    <!-- DataTables Bootstrap 4 CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css">
    <!-- DataTables Responsive CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap4.min.css">
@endsection
<style>
.btn-sm {
    padding: 4px 8px !important;
}
</style>
@section('admin-content')

<!-- page title area start -->
<div class="page-title-area">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">{{ __('Investors') }}</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('admin.dashboard') }}">{{ __('Dashboard') }}</a></li>
                    <li><span>{{ __('All Investors') }}</span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            @include('backend.layouts.partials.logout')
        </div>
    </div>
</div>
<!-- page title area end -->

<div class="main-content-inner">
    <div class="row">
        <!-- data table start -->
        <div class="col-12 mt-5">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title float-left">{{ __('Investors') }}</h4>
                    <p class="float-right mb-2">
                        @if (auth()->user()->can('investor.edit'))
                            <a class="btn btn-primary btn-sm text-white" href="{{ route('admin.admins.create') }}">
                                <i class="fa fa-plus"></i> {{ __('Create New Investor') }}
                            </a>
                        @endif
                    </p>
                    <div class="clearfix"></div>
                    <div class="data-tables">
                        @include('backend.layouts.partials.messages')
                        <table id="admins-table" class="table table-striped table-bordered table-responsive">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>investor Id</th>
                                    <th>First Name</th>
                                    <th>Last Name</th>
                                    <th>Mobile</th>
                                    <th>Email</th>
                                    <th>Address</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($admins as $key => $admin)
                                     <tr>
										<td>{{ $key+1 }}</td>
										<td>{{ $admin->referral_id }}</td>
										<td>{{ $admin->first_name }}</td>
										<td>{{ $admin->last_name }}</td>
										<td>{{ $admin->mobile }}</td>
										<td>{{ $admin->email }}</td>
										<td>{{ $admin->address }}</td>
										<td>
											@if (auth()->user()->can('investor.edit'))
												<a class="btn btn-sm btn-warning text-white " href="{{url('admin/upload/document')}}/{{$admin->id }}">
													Upload Documents
												</a><br>
												<a class="btn btn-sm btn-primary text-white " href="{{ route('admin.admins.edit', $admin->id) }}">
													Edit
												</a>
											@endif

											@if (auth()->user()->can('investor.delete'))
													<form action="{{ route('admin.admins.destroy', $admin->id) }}" method="POST" style="display:inline;">
										@csrf @method('DELETE')
										<button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
									</form>
											@endif
										</td>
									</tr>

                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- data table end -->
    </div>
</div>
@endsection

@section('scripts')
    <!-- jQuery (Ensure it is loaded before DataTables) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables -->
    <script src="https://cdn.datatables.net/1.10.19/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.18/js/dataTables.bootstrap4.min.js"></script>

    <script>
        $(document).ready(function () {
            $('#admins-table').DataTable({
                "responsive": true,
                "ordering": true,
                "paging": true,
                "searching": true
            });
        });
    </script>
@endsection
