@extends('backend.layouts.master')

@section('title', 'Edit Investment - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Edit Investment</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.investments.update', $investment->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="form-group">
                            <label>Investor</label>
                            <select class="form-control" name="investor_id" required>
                                @foreach($investors as $investor)
                                    <option value="{{ $investor->id }}" {{ $investment->investor_id == $investor->id ? 'selected' : '' }}>
                                        {{ $investor->first_name }} {{ $investor->last_name }} ({{ $investor->email }})
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label>Project</label>
                            <select class="form-control" name="project_id" required>
                                @foreach($projects as $project)
                                    <option value="{{ $project->id }}" {{ $investment->project_id == $project->id ? 'selected' : '' }}>
                                        {{ $project->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        
                        <div class="form-group">
                            <label>Share Price</label>
                            <input type="text" class="form-control" name="share_price" value="{{ $investment->share_price }}" required>
                        </div>
						
                        <div class="form-group">
                            <label>Upload Share Certificate (PDF)</label>
                            <input type="file" name="share_certificate" class="form-control-file" accept=".pdf">
                            @if($investment->share_certificate)
                                <p>Current file: <a href="{{ asset($investment->share_certificate) }}" target="_blank" class="btn btn-sm btn-primary">View Certificate 📄</a></p>
                            @endif
                        </div>

                        <div class="form-group">
                            <label>Payment Details</label>
                            <div class="row">
								<div class="col-md-6">
									<label>Amount Invested</label>
									<input type="text" class="form-control" name="amount_invested" value="{{ $investment->amount_invested }}" required>
								</div>
								<div class="col-md-6">
                            <label>Number Of Shares</label>
                            <input type="text" class="form-control" name="number_of_share" value="{{ $investment->number_of_share }}" required>
                        </div>


                                <div class="col-md-6">
                                    <label>Transaction Number</label>
                                    <input type="text" class="form-control" name="transaction_number" value="{{ $investment->transaction_number }}" required>
                                </div>
                                <div class="col-md-6">
                                    <label>Transaction Date</label>
                                    <input type="date" class="form-control" name="transaction_date" value="{{ $investment->transaction_date }}" required>
                                </div>
                            </div>
                        </div>

                        <br>
                        <button type="submit" class="btn btn-primary">Update</button>
                        <a href="{{ route('admin.investments.index') }}" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
