@extends('backend.layouts.master')

@section('title', 'Project Details')

@section('admin-content')

<!-- Page Title Area Start -->
<div class="page-title-area p-4">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">Project Details</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                    <li><a href="{{ route('admin.projects.index') }}">All Projects</a></li>
                    <li><span>View Project</span></li>
                </ul>
            </div>
        </div>
        <div class="col-sm-6 clearfix">
            @include('backend.layouts.partials.logout')
        </div>
    </div>
</div>
<!-- Page Title Area End -->

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title">Project Details</h4>

                    <table class="table table-bordered">
                        <tr>
                            <th>Name:</th>
                            <td>{{ $project->name }}</td>
                        </tr>
                        <tr>
                            <th>Description:</th>
                            <td>{{ $project->description }}</td>
                        </tr>
                        <tr>
                            <th>Status:</th>
                            <td>
                                @if ($project->status === 'Active')
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-danger">Inactive</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Launch Status:</th>
                            <td>
                                @if ($project->launching_soon)
                                    ✅ Launched
                                @else
                                    ❌  Launching Soon
                                @endif
                            </td>
                        </tr>
                       {{-- <tr>
                            <th>IRR:</th>
                            <td>{{ $project->target_irr }}</td>
                        </tr>
						<tr>
                            <th>ROI:</th>
                            <td>{{ $project->roi }}</td>
                        </tr>--}}
                        <tr>
                            <th>Asset Value:</th>
                            <td>{{ $project->asset_value }}</td>
                        </tr>
                        <tr>
                            <th>Asset Type:</th>
                            <td>{{ $project->asset_type }}</td>
                        </tr>
                        <tr>
                            <th>Minimum Investment:</th>
                            <td>{{ $project->minimum_investment }}</td>
                        </tr>
                        <tr>
                            <th>Image:</th>
                            <td>
                                @if ($project->image)
                                    <img src="{{ asset($project->image) }}" alt="Project Image" width="200">
                                @else
                                    <p>No image uploaded</p>
                                @endif
                            </td>
                        </tr>
                    </table>

                    <a href="{{ route('admin.projects.index') }}" class="btn btn-secondary">Back</a>
                    <a href="{{ route('admin.projects.edit', $project->id) }}" class="btn btn-primary">Edit</a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
