@extends('backend.layouts.master')

@section('title', 'Create Project Share Price - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Create New Project Share Price</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{ route('admin.projectshareprice.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        

                        <div class="form-group">
                            <label>Project</label>
                            <select class="form-control" name="project_id" required>
                                <option value="">Select Project</option>
                                @foreach($projects as $project)
                                    <option value="{{ $project->id }}">{{ $project->name }}</option>
                                @endforeach
                            </select>
                        </div>

                     
                        
						<div class="form-group">
                            <label>Share Price</label>
                            <input type="text" class="form-control" name="share_price" required>
                        </div>

                       
                       

                        <div class="form-group">
                           
                            <div class="row">
								
                                <div class="col-md-6">
                                    <label>Transaction Date</label>
                                    <input type="date" class="form-control" name="transaction_date" required>
                                </div>
                            </div>
                        </div>

                        <br>
                        <button type="submit" class="btn btn-primary">Create</button>
                        <a href="{{ route('admin.projectshareprice.index') }}" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
