@extends('backend.layouts.master')

@section('title', 'Project Share Price Details - Admin Panel')

@section('admin-content')

<div class="page-title-area p-4">
    <h4 class="page-title">Project Share Price Details</h4>
</div>

<div class="main-content-inner mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Project Share Price Information</h5>
                    <table class="table table-bordered">
                      
                        <tr>
                            <th>Project Name</th>
                            <td>{{ $projectshareprice->project->name }}</td>
                        </tr>
                       
                        <tr>
                            <th>Share Price</th>
                            <td>{{ number_format($projectshareprice->share_price, 2) }}</td>
                        </tr>
                        
                        <tr>
                            <th>Transaction Date</th>
                            <td>{{ date('d M Y', strtotime($projectshareprice->transaction_date)) }}</td>
                        </tr>
                       
                    </table>

                    <a href="{{ route('admin.projectshareprice.index') }}" class="btn btn-secondary">Back</a>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
