<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Delete Your Account</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }

        .container {
            background: #fff;
            padding: 30px 40px;
            border-radius: 10px;
            box-shadow: 0 8px 16px rgba(0,0,0,0.1);
            max-width: 500px;
            width: 100%;
        }

        h2 {
            color: #dc3545;
            text-align: center;
            margin-bottom: 25px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
        }

        input[type="text"] {
            width: 100%;
            padding: 12px 15px;
            margin-bottom: 20px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 16px;
        }

        button {
            width: 100%;
            padding: 12px;
            background-color: #dc3545;
            color: #fff;
            font-size: 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #c82333;
        }

        a {
            display: block;
            text-align: center;
            margin-top: 20px;
            color: #007bff;
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }

        .status {
            color: green;
            margin-bottom: 15px;
            text-align: center;
        }

        .error {
            color: red;
            margin-bottom: 15px;
        }

        ul {
            padding-left: 18px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Delete Your Account</h2>

        @if(session('status'))
            <div class="status">{{ session('status') }}</div>
        @endif
 
        @if($errors->any())
            <div class="error">
                <ul>
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ url('delete-account') }}">
            @csrf
            <label for="email">Your Email Address</label>
            <input type="text" name="email" placeholder="you@example.com" required>

            <button type="submit">Submit Deletion Request</button>
        </form>

        <a href="{{ url()->previous() }}">Cancel and Go Back</a>
    </div>
</body>
</html>
