<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\ProjectController;
use App\Http\Controllers\API\MyTeamController;
use App\Http\Controllers\Backend\AdminsController;
/*
|--------------------------------------------------------------------------
| API Routes  
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:api')->get('/user', function (Request $request) {
//     return $request->user();
// }); 

 Route::post('/investors', [AdminsController::class, 'storeInvestorApi'])->name('api.investors.store');
 Route::post('/investors/approveaccountmail', [AdminsController::class, 'approveaccountmail'])->name('api.investors.approveaccountmail');
		
Route::post('referralidsuggestions', [AuthController::class, 'getReferralSuggestions']);
Route::post('countries', [AuthController::class, 'countries']);
Route::post('states', [AuthController::class, 'states']);
Route::post('send-otp1', [AuthController::class, 'sendOtp1']);
Route::post('delete-account', [AuthController::class, 'deleteAccount']);
Route::post('send-otp', [AuthController::class, 'sendOtp']);
Route::post('verify-otp', [AuthController::class, 'verifyOtp']);
Route::post('customer/send-otp', [AuthController::class, 'sendOtpcustomer']);
Route::post('customer/verify-otp', [AuthController::class, 'verifyOtpcustomer']);
Route::post('franchise/send-otp', [AuthController::class, 'sendOtpfranchise']);
Route::post('franchise/verify-otp', [AuthController::class, 'verifyOtpfranchise']);
Route::post('admin-login', [AuthController::class, 'adminlogin']);
Route::post('test', [AuthController::class, 'test']);
Route::post('projects', [ProjectController::class, 'projects']);
Route::post('projects/details', [ProjectController::class, 'projectdetail']);
Route::post('investment/details', [ProjectController::class, 'investmentdetail']); 
 Route::post('upload/profile-picture2', [AuthController::class, 'uploadProfilePicture2']);
 Route::post('getInvestorDetails', [AuthController::class, 'getInvestorDetails']);
	
	Route::post('/upload/documents2', [AuthController::class, 'uploadDocuments2']);
Route::middleware('auth:sanctum')->group(function () {
	Route::post('update/profile', [AuthController::class, 'updateProfile']); 
	Route::post('add/myteam', [AuthController::class, 'addmyteam']);
	Route::post('update/myteam', [AuthController::class, 'updatemyteam']);
	Route::post('edit/myteam', [AuthController::class, 'editmyteam']);
	Route::post('delete/myteam', [AuthController::class, 'deletemyteam']);
	Route::post('edit/profile', [AuthController::class, 'editprofile']);
	Route::post('myteam', [AuthController::class, 'myteam']);
	Route::post('allusers', [AuthController::class, 'allusers']);
	Route::post('logout', [AuthController::class, 'logout']); 
	Route::post('upload/profile-picture', [AuthController::class, 'uploadProfilePicture']);
	Route::post('/upload/documents', [AuthController::class, 'uploadDocuments']);
	Route::post('/investments', [ProjectController::class, 'getInvestmentsByInvestor']);
	Route::post('/accept-investment-terms', [ProjectController::class, 'acceptInvestmentTerms']);

}); 