"use client";
import React, { Fragment } from "react";
import { User } from "react-feather";
import { Col, Container, Row, Alert } from "reactstrap";
import { useRouter } from 'next/navigation';
import { useDispatch, useSelector } from 'react-redux';
import { setMobileNumber, setOtp, setIsOtpSent, setMessage } from '../../../../../redux-toolkit/reducers/loginSlice'; // Updated path
import Breadcrumb from "@/layout/Breadcrumb/Breadcrumb";
import NavbarThree from "@/layout/headers/NavbarThree";
import FooterThree from "@/layout/footers/FooterThree";
import NavbarOne from "@/layout/headers/NavbarOne";
import FooterOne from "@/layout/footers/FooterOne";

const Logincustomer = () => {
  const router = useRouter();
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;

  const dispatch = useDispatch();
  const { mobileNumber, otp, isOtpSent, message } = useSelector(state => state.login);

  const handleSendOtp = async (e) => {
    e.preventDefault();
    dispatch(setMessage({ text: '', type: '' }));

    try {
      const response = await fetch(`${BASE_URL}/customer/send-otp`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ mobile: mobileNumber }), // Role removed
      });

      if (response.ok) {
		const data = await response.json();
		if(data.code != '0')
		{
			dispatch(setIsOtpSent(true));
		}
        dispatch(setMessage({ text: data.message, type: 'success' }));
      } else {
        const errorData = await response.json();
        dispatch(setMessage({ text: errorData.message, type: 'error' }));
      }
    } catch (error) {
      console.error("Error sending OTP:", error);
      dispatch(setMessage({ text: "Failed to send OTP, please try again.", type: 'error' }));
    }
  };

  const handleVerifyOtp = async (e) => {
    e.preventDefault();
    dispatch(setMessage({ text: '', type: '' }));

    try {
      const response = await fetch(`${BASE_URL}/customer/verify-otp`, {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ mobile: mobileNumber, otp }), // Role removed
      });

      if (response.ok) {
        const data = await response.json();
        localStorage.setItem('token', data.token);
        localStorage.setItem('user', JSON.stringify(data.data));

        dispatch(setMessage({ text: "Login successful!", type: 'success' }));
        router.push('/pages/user-panel/user-dashboard');
      } else {
        const errorData = await response.json();
        dispatch(setMessage({ text: errorData.message, type: 'error' }));
      }
    } catch (error) {
      console.error("Error verifying OTP:", error);
      dispatch(setMessage({ text: "OTP verification failed, please try again.", type: 'error' }));
    }
  };

  return (
    <Fragment>
      <NavbarOne />
      <Breadcrumb innerHeader = "Customer Login" />
      <section className='login-wrap'>
        <Container>
          <Row className='log-in'>
            <Col xl='5' lg='6' md='8' sm='10'>
              <div className='theme-card'>
                <div className='title-3 text-start'>
                  <h2>Customer Log in / Sign up</h2>
                </div>
                <form onSubmit={isOtpSent ? handleVerifyOtp : handleSendOtp}>
                  {message.text && (
                    <Alert color={message.type === 'success' ? 'success' : 'danger'}>
                      {message.text}
                    </Alert>
                  )}

                  {/* Mobile number input */}
                  <div className='form-group'>
                    <div className='input-group'>
                      <div className='input-group-prepend'>
                        <div className='input-group-text'> 
                          <User />
                        </div>
                      </div>
                      <input
                        type='text'
                        className='form-control'
                        placeholder='Enter Email'
                        value={mobileNumber}
                        onChange={(e) => dispatch(setMobileNumber(e.target.value))}
                        required
                      />
                    </div>
                  </div>

                  {/* OTP input */}
                  {isOtpSent && (
                    <div className='form-group'>
                      <div className='input-group'>
                        <div className='input-group-prepend'>
                          <div className='input-group-text'>OTP</div>
                        </div>
                        <input
                          type='text'
                          className='form-control'
                          placeholder='Enter OTP'
                          value={otp}
                          onChange={(e) => dispatch(setOtp(e.target.value))}
                          required
                        />
                      </div>
                    </div>
                  )}

                  <div className="d-flex justify-content-center">
                    <button type='submit' className='btn btn-gradient text-center btn-pill me-sm-3 me-2'>
                      {isOtpSent ? "Verify OTP" : "Send OTP"}
                    </button>
                  </div>
                </form>
              </div>
            </Col>
          </Row>
        </Container>
      </section>
      <FooterOne />
    </Fragment>
  );
};

export default Logincustomer;
