"use client";
import React, { Fragment, useEffect, useState } from "react";
import NavbarThree from "@/layout/headers/NavbarThree";
import FooterThree from "@/layout/footers/FooterThree";
import Breadcrumb from "@/layout/Breadcrumb/Breadcrumb";
import dynamic from "next/dynamic";
import NavbarOne from "@/layout/headers/NavbarOne";
import FooterOne from "@/layout/footers/FooterOne";

const BodyContent = dynamic(() => import("../../../../../components/pages/userPanel"), {
  ssr: false,
});


const UserDashboard = () => {
  const [activeTab, setActiveTab] = useState("EditProfile");

  useEffect(() => {
    const checkUserData = () => {
      // Fetch user data from localStorage
      const userData = localStorage.getItem("user");
      let user = {};

      if (userData) {
        try {
          user = JSON.parse(userData); // Parse the user object
        } catch (error) {
          console.error("Failed to parse user data from localStorage", error);
        }
      }

      // Required fields to validate
      const fields = ['first_name', 'middle_name', 'last_name', 'father_name', 'mobile', 'email'];
      const allFilled = fields.every((field) => user[field] && user[field].trim() !== "");

      // Set active tab based on field validation
      setActiveTab(user.first_login=='1' ? "Profile" : "EditProfile");
    };

    checkUserData();
  }, []);

  return (
    <Fragment>
      <NavbarOne/>
      <Breadcrumb />
      <BodyContent active={activeTab} />
      <FooterOne/>
    </Fragment>
  );
};

export default UserDashboard;
