import React from 'react';
import axios from 'axios';

const LogoutButton = () => {
  const handleLogout = async () => {
    try {
      // Call your logout API endpoint
      const response = await axios.post(`${process.env.NEXT_PUBLIC_BASE_URL}/logout`, {}, {
        headers: {
          Authorization: `Bearer ${localStorage.getItem('token')}`
        }
      });
	  if (response.data.message === "Unauthenticated.") {
        localStorage.clear();
        window.location.href = '/';
      }
      if (response.status === 200) {
        // Clear user-related data from localStorage
        localStorage.removeItem('token');
        localStorage.removeItem('user');

        // Reload the page to reset the state
       window.location.href = "/"; 
      } else {
        console.error('Logout failed', response.data);
      }
    } catch (error) {
		
      console.error('An error occurred during logout:', error);
	    if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };

  return (
    <button onClick={handleLogout} className="btn btn-sm btn-light">
      Logout
    </button>
  );
};

export default LogoutButton;
