import React, { useEffect, useState } from "react";
import { CheckSquare, Mail, MapPin } from "react-feather";
import { Row, Col, Alert,Nav, NavItem, NavLink } from "reactstrap";
import ReviewStarr from "../../../elements/ReviewStarr";
import ChangeDetails from "./ChangeDetails";
import EditProfile from "./EditProfile";
import axios from 'axios';

const MyProfileTab = ({ activeTab, setActiveTab }) => {
  const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL;
  const [modal, setModal] = useState();
  const [profileDetail, setProfileDetail] = useState({});
  const [successMessage, setSuccessMessage] = useState("");
  const [errorMessage, setErrorMessage] = useState("");

  useEffect(() => {
    const fetchProfile = async () => {
      const token = localStorage.getItem('token');
      if (!token) {
        setErrorMessage("You need to be logged in to view your profile.");
        return;
      }

      try {
        const response = await axios.post(`${BASE_URL}/edit/profile`, {}, {
          headers: {
            'Authorization': `Bearer ${token}`,
          },
        });
        setProfileDetail(response.data.data);
      } catch (error) {
        console.error("Error fetching profile:", error);
        setErrorMessage("Error fetching profile: " + (error.response?.data?.message || "Unknown error occurred."));
      }
    };

    fetchProfile();
  }, []);

  const handleProfileUpdate = async (updatedProfile) => {
    const token = localStorage.getItem('token');
    if (!token) {
      setErrorMessage("You need to be logged in to update your profile.");
      return;
    }

    try {
      const response = await axios.post(`${BASE_URL}/edit/profile`, updatedProfile, {
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
        },
      });
      setProfileDetail(response.data.data);
      setSuccessMessage("Profile updated successfully!");
    } catch (error) {
      console.error("Error updating profile:", error);
      setErrorMessage("Error updating profile: " + (error.response?.data?.message || "Unknown error occurred."));
    }
  };

  return (
    <div className="dashboard-content">
      <div className="my-profile" id="profile">
        {successMessage && <Alert color="success">{successMessage}</Alert>}
        {errorMessage && <Alert color="danger">{errorMessage}</Alert>}
        <div className="profile-info">
          <div className="common-card">
            <div className="user-name media">
              <div className="media-body">
                <h5>
                  {profileDetail.first_name} {profileDetail.middle_name} {profileDetail.last_name} {' '} 
                   <span className="label label-success"> {profileDetail.role_name} </span>
                </h5>
				{/*  <ReviewStarr rating={4} /> */}
              </div>
			   <button
						className={activeTab === "EditProfile" ? "btn btn-primary active" : "btn btn-success"}
						onClick={() => setActiveTab("EditProfile")}
					  >
						Edit Profile
					 
					</button>
              {/* <span className="label label-light label-flat" onClick={() => setModal("editProfile")}>
                Edit
</span> */}
            </div>
            <ul className="user-detail">
              <li>
                <MapPin />
                <span>{profileDetail.city}, {profileDetail.state?.name}</span>
              </li>
              <li>
                <Mail />
                <span>{profileDetail.email}</span>
              </li>
            </ul>
            <p className="font-roboto">{profileDetail.address}</p>
          </div>
          <div className="common-card">
            <Row>
              <Col md="12">
                <div className="information-detail">
                  <div className="common-header">
                    <h5>My Profile</h5>
					 
					 
                  </div>
                  <div className="information">
                    <Row>
                      <Col md="6">
                        <ul>
                          <li><strong>Title:</strong> {profileDetail.title}</li>
                          <li><strong>First Name:</strong> {profileDetail.first_name}</li>
                          <li><strong>Middle Name:</strong> {profileDetail.middle_name}</li>
                          <li><strong>Last Name:</strong> {profileDetail.last_name}</li>
                          <li><strong>Father Name:</strong> {profileDetail.father_name}</li>
                          <li><strong>Mobile:</strong> {profileDetail.mobile}</li>
                          <li><strong>Email:</strong> {profileDetail.email}</li>
                          <li><strong>Address:</strong> {profileDetail.address}</li>
                       
                          <li><strong>State :</strong> {profileDetail.state?.name}</li>
                          <li><strong>Country :</strong> {profileDetail.country?.name}</li>
                          <li><strong>City:</strong> {profileDetail.city}</li>
                          <li><strong>PAN No.:</strong> {profileDetail.pan}</li>
                          <li><strong>Aadhar Number:</strong> {profileDetail.aadhar_number}</li>
                        </ul>
                      </Col>
                      <Col md="6">
                        <ul>
                          <li><strong>Nominee Name:</strong> {profileDetail.nominee_name}</li>
                          <li><strong>Nominee Relationship:</strong> {profileDetail.nominee_relationship}</li>
                          <li><strong>Nominee Contact No.:</strong> {profileDetail.nominee_contact}</li>
                          <li><strong>Bank Name:</strong> {profileDetail.bank_name}</li>
                          <li><strong>Account Number:</strong> {profileDetail.account_number}</li>
                          <li><strong>IFSC Code:</strong> {profileDetail.ifsc_code}</li>
                          <li><strong>Account Type:</strong> {profileDetail.account_type}</li>
                         
						 {/*<li><strong>Years of  Experience in Real Estate:</strong> {profileDetail.years_of_exp}</li>
						 <li><strong>Highest Education Qualification:</strong> {profileDetail.education_qualification}</li>*/}
                          <li><strong>Company Name:</strong> {profileDetail.company_name}</li>
                          <li><strong>Company GST No.:</strong> {profileDetail.company_gst}</li>
                          <li><strong>Company PAN No.:</strong> {profileDetail.company_pan_number}</li>
                          
                          <li><strong>My ID:</strong> {profileDetail.referral_id}</li>
                        </ul>
                      </Col>
                    </Row>
                  </div>
                </div>
              </Col>
            </Row>
          </div>
        </div>
      </div>
      <EditProfile 
        toggle={"editProfile" === modal} 
        setModal={setModal} 
        profileDetail={profileDetail} 
        setProfileDetail={handleProfileUpdate} 
      />
      <ChangeDetails
        toggle={"changeEmail" === modal}
        setModal={setModal}
        detail={"email address"}
        profileDetail={profileDetail}
        setProfileDetail={setProfileDetail}
        old={profileDetail.email}
      />
      <ChangeDetails
        toggle={"changePass" === modal}
        setModal={setModal}
        detail={"password"}
        profileDetail={profileDetail}
        setProfileDetail={setProfileDetail}
        old={profileDetail.password}
      />
    </div>
  );
};

export default MyProfileTab;
