import React, { useEffect, useState } from "react";
import axios from "axios";
import {
  Table,
  Alert,
  Col,
  Row,
  Button,
  Modal,
  ModalHeader,
  ModalBody,
  ModalFooter,
  Form,
  FormGroup,
  Label,
  Input,
} from "reactstrap";

const BASE_URL = process.env.NEXT_PUBLIC_BASE_URL || "";

const MyTeamTab = () => {
  const [teamData, setTeamData] = useState([]);
  const [countries, setCountries] = useState([]);
  const [states, setStates] = useState([]);
  const [errorMessage, setErrorMessage] = useState("");
  const [successMessage, setSuccessMessage] = useState("");
  const [editModal, setEditModal] = useState(false);
  const [editData, setEditData] = useState(null);
  const [addModal, setAddModal] = useState(false);
  const [addData, setAddData] = useState({});
  const [isReferralValid, setIsReferralValid] = useState(true);
    const [referralSuggestions, setReferralSuggestions] = useState([]);
   const [errorMessage2, setErrorMessage2] = useState("");
     const [isReferralLoading, setIsReferralLoading] = useState(false);
  const [expandedRows, setExpandedRows] = useState({});
	
  const fetchCountries = async () => {
    try {
      const response = await axios.post(`${BASE_URL}/countries`);
      setCountries(response.data.data || []);
    } catch (error) {
      console.error("Error fetching countries:", error);
    }
  };

  const fetchStates = async (country_id) => {
    try {
      const response = await axios.post(`${BASE_URL}/states`, { country_id });
      setStates(response.data.data || []);
    } catch (error) {
      console.error("Error fetching states:", error);
    }
  };
 const toggleRow = (id) => {
    setExpandedRows((prev) => ({
      ...prev,
      [id]: !prev[id],
    }));
  };
 const userdata = JSON.parse(localStorage.getItem('user'));
  const fetchTeamData = async (searchTerm = "") => {
    const token = localStorage.getItem("token");

    if (!token) {
        setErrorMessage("You need to be logged in to view team data.");
        return;
    }

    try {
        const response = await axios.post(
            `${BASE_URL}/myteam`,
            {
                search: searchTerm, // Pass search term as part of request body
            },
            {
                headers: { Authorization: `Bearer ${token}` },
            }
        );

        if (response.data.message === "Unauthenticated.") {
            localStorage.clear();
            window.location.href = '/';
        }

        if (response.data.success) {
            // If search is done on the server-side
            setTeamData(response.data.data);
        } else {
            setErrorMessage("Failed to fetch team data.");
        }
    } catch (error) {
        console.error("Error fetching team data:", error);
        setErrorMessage("Error fetching team data.");
        
        if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
            localStorage.clear();
            window.location.href = '/';
        }
    }
};

// Function to handle search input change
const handleSearchChange = (event) => {
    const searchTerm = event.target.value;
    fetchTeamData(searchTerm); // Fetch data with the new search term
};

// Example of how you might use this in an input field

const fetchReferralSuggestions = async (referralId) => {
  if (!referralId) {
    setReferralSuggestions([]);
    setErrorMessage2("");
    return;
  }

  setIsReferralLoading(true);
  try {
    const token = localStorage.getItem('token');
    const response = await axios.post(
      `${BASE_URL}/referralidsuggestions`,
      { my_referral_id: referralId },
      {
        headers: {
          'Authorization': `Bearer ${token}`,
          'Content-Type': 'application/json',
        },
      }
    );

    const suggestions = response.data.data || [];
    setReferralSuggestions(suggestions);

    // Show error message if no suggestions are found
    if (suggestions.length === 0) {
      setErrorMessage2("Invalid referral ID.");
	  setIsReferralValid(false);
    } else {
      setErrorMessage2("");
	  setIsReferralValid(true);
    }
  } catch (error) {
    console.error("Error fetching referral suggestions:", error);
    setReferralSuggestions([]);
    setErrorMessage2("Invalid referral ID.");
	 setIsReferralValid(false);
  } finally {
    setIsReferralLoading(false);
  }
};

  useEffect(() => {
    fetchCountries();
    fetchTeamData();
  }, []);

  useEffect(() => {
    if (editData?.country_id) fetchStates(editData.country_id);
    if (addData?.country_id) fetchStates(addData.country_id);
  }, [editData?.country_id,addData?.country_id]);


const renderChildren = (children, level) => {
  return children.map((child) => (
    <React.Fragment key={child.id}>
      <tr className={`bg-light level-${level}`}>
        <td>
          {Array.isArray(child.children) && child.children.length > 0 && (
            <Button
              color="link"
              size="sm"
              onClick={() => toggleRow(child.id)}
            >
              {expandedRows[child.id] ? "-" : "+"}
            </Button>
          )}
        </td>
        <td>{child.level || "N/A"}</td>
        <td>{child.referral_id || "N/A"}</td>
        <td>{child.first_name || "N/A"}</td>
        <td>{child.last_name || "N/A"}</td>
        <td>{child.mobile || "N/A"}</td>
        <td>{child.email || "N/A"}</td>
        <td>
          {child.city || "N/A"}, {child.state?.name || "N/A"}
        </td>
        <td>
          {userdata?.role_name === "franchise" && (
            <td>
              <Button
                color="primary"
                size="sm"
                className="d-flex align-items-center"
                onClick={() => handleEdit(child.id)}
              >
                <i className="fa fa-edit me-1"></i>Edit
              </Button> &nbsp;
              {/* Custom Switch Toggle for Activate/Deactivate */}
              <div className="switch-container d-flex align-items-center">
                <label className="switch">
                  <input
                    type="checkbox"
                    checked={child.status === 1}
                    onChange={() => handleDelete(child.id, child.status === 1 ? 0 : 1)}
                  />
                  <span className="slider"></span>
                </label>
                {/*<span>{child.status === 1 ? 'Deactivate' : 'Activate'}</span>*/}
              </div>
            </td>
          )}
        </td>
      </tr>
      {expandedRows[child.id] &&
        Array.isArray(child.children) &&
        child.children.length > 0 &&
        renderChildren(child.children, level + 1)}
    </React.Fragment>
  ));
};




  const handleDelete = async (id, status) => {
  // Confirm the action
  if (!window.confirm("Are you sure?")) return;

  // Get the token from localStorage
  const token = localStorage.getItem("token");
  if (!token) {
    setErrorMessage("You need to be logged in.");
    return;
  }

  try {
    // Send the request to the API
    const response = await axios.post(
      `${BASE_URL}/delete/myteam`, 
      { id, status },  // Pass both id and status
      { headers: { Authorization: `Bearer ${token}` } }
    );

    // Handle authentication errors
    if (response.data.message === "Unauthenticated.") {
      localStorage.clear();
      window.location.href = '/';
      return; // Exit if unauthenticated
    }

    // Success case
    if (response.data.code === "1") {
      // Update team data by filtering out the deleted member
    setTeamData(teamData.map((member) =>
        member.id === id ? { ...member, status: status } : member
      ));
      setErrorMessage(""); // Clear any error messages
      setSuccessMessage(response.data.message); // Show success message
    } else {
      setErrorMessage("Failed to update team member status.");
      setSuccessMessage(""); // Clear any success message
    }

  } catch (error) {
    // Handle any errors in the API call
    console.error("Error updating team member status:", error);
    setErrorMessage("Error updating team member status.");
    setSuccessMessage(""); // Clear success message
    if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
      localStorage.clear();
      window.location.href = '/';
    }
  }
};

 const handleEdit = async (id) => {
    const token = localStorage.getItem("token");
    if (!token) {
      setErrorMessage("You need to be logged in to edit team members.");
      return;
    }

    try {
      const response = await axios.post(`${process.env.NEXT_PUBLIC_BASE_URL}/edit/myteam`, { id }, {
        headers: { Authorization: `Bearer ${token}` },
      });
	if (response.data.message === "Unauthenticated.") {
        localStorage.clear();
        window.location.href = '/';
      }
      if (response.data.code=="1") {
        setEditData(response.data.data);
        setEditModal(true);
		 setErrorMessage("");
	   setSuccessMessage('');
      } else {
        setErrorMessage("Failed to fetch team member details.");
      }
    } catch (error) {
      console.error("Error fetching team member details:", error);
      setErrorMessage("Error fetching team member details.");
	   if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };
  const handleUpdate = async () => {
    const token = localStorage.getItem("token");
    if (!token) {
      setErrorMessage("You need to be logged in to update team members.");
      return;
    }

    try {
      const response = await axios.post(
        `${BASE_URL}/update/myteam`,
        editData,
        { headers: { Authorization: `Bearer ${token}` } }
      );
	  if (response.data.message === "Unauthenticated.") {
        localStorage.clear();
        window.location.href = '/';
      }
      if (response.data.code == "1") {
        setTeamData(teamData.map((member) => (member.id === editData.id ? editData : member)));
        setEditModal(false);
		 setSuccessMessage(response.data.message);
        setErrorMessage("");
      } else {
        setErrorMessage("Failed to update team member.");
		 setSuccessMessage('');
      }
    } catch (error) {
      console.error("Error updating team member:", error);
      setErrorMessage("Error updating team member: "+ (error.response?.data?.message || "Unknown error occurred."));
	   setSuccessMessage('');
	    if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };
  
   const handleInputChange = (e) => {
    const { name, value } = e.target;
    setEditData({ ...editData, [name]: value });
  };
   const handleAddInputChange = (e) => {
    const { name, value } = e.target;
    setAddData({ ...addData, [name]: value });
	if (name === "my_referral_id") {
      fetchReferralSuggestions(value);
    }
  };
    const handleReferralSelect = (referral) => {
    setInputs((prevInputs) => ({
      ...prevInputs,
      my_referral_id: referral.referral_id,
    }));
    setReferralSuggestions([]);
	setErrorMessage2("");
  };
  const handleAddMember = async () => {
	   setSuccessMessage(" ");
	   setErrorMessage(" ");
    const token = localStorage.getItem("token");
    if (!token) {
      setErrorMessage("You need to be logged in to add team members: " + (error.response?.data?.message || "Unknown error occurred."));
      return;
    }

    try {
      const response = await axios.post(
        `${BASE_URL}/add/myteam`,
        addData,
        { headers: { Authorization: `Bearer ${token}` } }
      );
	  if (response.data.message === "Unauthenticated.") {
        localStorage.clear();
        window.location.href = '/';
      }
	    setSuccessMessage('');
	   setErrorMessage('');
      if (response.data.code == "1") {
        setTeamData([...teamData, response.data.data]);
        setAddModal(false);
        setErrorMessage("");
		 setSuccessMessage(response.data.message);
        setAddData({});
      }
		else if (response.data.code == "0") {
         setErrorMessage(response.data.message);
      }	  else {
        setErrorMessage("Failed to add team member.");
		 setSuccessMessage('');
      }
    } catch (error) {
      console.error("Error adding team member:", error);
      setErrorMessage("Error adding team member." + (error.response?.data?.message || "Unknown error occurred."));
	   setSuccessMessage('');
	   if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };
  
  return (
    <div className="team-data-table" id="my-team">
      {errorMessage && <Alert color="danger">{errorMessage}</Alert>}
	   {successMessage && <Alert color="success">{successMessage}</Alert>}
	    {userdata?.role_name == 'franchise' && (
	 <Button color="success" onClick={() => setAddModal(true)}>
        Add Channel Partner
      </Button>
	  )}
	  
	 <div style={{ display: 'flex', justifyContent: 'center', alignItems: 'center' }}>
		<input  type="text"  placeholder="Search team" onChange={handleSearchChange} 
			style={{
				padding: '8px 16px',
				fontSize: '16px',
				borderRadius: '4px',
				border: '1px solid #ccc',
				
			}} 
		/>
	</div>

      <Table striped responsive>
  <thead>
    <tr>
      <th>+</th>
      <th>Level</th>
      <th>Channel Partner Code</th>
      <th>First Name</th>
      <th>Last Name</th>
      <th>Mobile</th>
      <th>Email</th>
      <th>Address</th>
      {userdata?.role_name === "franchise" && <th>Actions</th>}
    </tr>
  </thead>
 <tbody>
  {teamData.length > 0 ? (
    teamData.map((member) => (
      <React.Fragment key={member.id}>
        <tr>
          <td>
            {Array.isArray(member.children) && member.children.length > 0 && (
              <Button
                color="link"
                size="sm"
                onClick={() => toggleRow(member.id)}
              >
                {expandedRows[member.id] ? "-" : "+"}
              </Button>
            )}
          </td>
          <td>2</td>
          <td>{member.referral_id || "N/A"}</td>
          <td>{member.first_name || "N/A"}</td>
          <td>{member.last_name || "N/A"}</td>
          <td>{member.mobile || "N/A"}</td>
          <td>{member.email || "N/A"}</td>
          <td>
            {member.city || "N/A"}, {member.state?.name || "N/A"}
          </td>
          {userdata.role_name === "franchise" && (
            <td>
              <Button
                color="primary"
                size="sm"
                className="d-flex align-items-center"
                onClick={() => handleEdit(member.id)}
              >
                <i className="fa fa-edit me-1"></i>Edit
              </Button>&nbsp;
              {/* Custom Switch Toggle for Activate/Deactivate */}
              <div className="switch-container d-flex align-items-center">
                <label className="switch">
                  <input
                    type="checkbox"
                    checked={member.status === 1}
                    onChange={() => handleDelete(member.id, member.status === 1 ? 0 : 1)}
                  />
                  <span className="slider"></span>
                </label>
		  {/*<span>{member.status === 1 ? 'Deactivate' : 'Activate'}</span>*/}
              </div>
            </td>
          )}
        </tr>
        {expandedRows[member.id] &&
          Array.isArray(member.children) &&
          member.children.length > 0 &&
          renderChildren(member.children, 1)}
      </React.Fragment>
    ))
  ) : (
    <tr>
      <td colSpan="8" style={{ textAlign: "center" }}>
        Data Not Found
      </td>
    </tr>
  )}
</tbody>

</Table>

{addModal && (
        <Modal size="lg" isOpen={addModal} toggle={() => setAddModal(!addModal)}>
          <ModalHeader toggle={() => setAddModal(!addModal)}>Add New Team Member</ModalHeader>
		  
          <ModalBody>
		  {errorMessage && <Alert color="danger">{errorMessage}</Alert>}
		   {successMessage && <Alert color="success">{successMessage}</Alert>}
              <Form>
			<div className="row">
			 <Col md="4" className="form-group">
					  <Label htmlFor="my_referral_id">Referral ID (who have referred you)</Label>
					  <Input
						name="my_referral_id"
						type="text"
						className="form-control " 
						placeholder="Referral ID"
						value={addData.my_referral_id || ""}
						onChange={handleAddInputChange}
					  />
					  {isReferralLoading && <div className="text-center">Loading...</div>}
					  
					  {/* Show error message if no valid suggestions */}
					  {errorMessage2 && referralSuggestions.length === 0 && !isReferralLoading && (
						<div className="text-danger mt-2">{errorMessage2}</div>
					  )}
				</Col>
               <Col md="4" className="form-group">
                  <Label htmlFor="title">Title</Label>
                 <select
					  name="title"
					  className="form-control"
					  value={addData.title || ""} // Default value is 'Mr' if 'title' is not provided
					  onChange={handleAddInputChange}
					>
					<option value="">Select Title</option>
					  <option value="Mr">Mr</option>
					  <option value="Ms">Ms</option>
					</select>
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="first_name">First Name</Label>
                  <Input name="first_name" type="text" className="form-control" value={addData.first_name || ""} onChange={handleAddInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="middle_name">Middle Name</Label>
                  <Input name="middle_name" type="text" className="form-control" value={addData.middle_name || ""} onChange={handleAddInputChange} />
                </Col>
                </div>
				<div className="row">
                <Col md="4" className="form-group">
                  <Label htmlFor="last_name">Last Name</Label>
                  <Input name="last_name" type="text" className="form-control" value={addData.last_name || ""} onChange={handleAddInputChange} />
                </Col>

                {/* Father's Name and Contact Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="father_name">Father's Name</Label>
                  <Input name="father_name" type="text" className="form-control" value={addData.father_name || ""} onChange={handleAddInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="mobile">Mobile</Label>
                  <Input name="mobile" type="text" className="form-control" value={addData.mobile || ""} onChange={handleAddInputChange} />
                </Col>
				</div>
				<div className="row">
                <Col md="4" className="form-group">
                  <Label htmlFor="email">Email</Label>
                  <Input name="email" type="email" className="form-control" value={addData.email || ""} onChange={handleAddInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="address">Address</Label>
                  <Input name="address" type="text" className="form-control" value={addData.address || ""} onChange={handleAddInputChange} />
                </Col>

                {/* Location Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="country_id">Country</Label>
                  <select name="country_id" className="form-control" value={addData.country_id || ""} onChange={handleAddInputChange}>
                    <option value="">Select Country</option>
                    {countries.map((country) => (
                      <option key={country.country_id} value={country.country_id}>{country.name}</option>
                    ))}
                  </select>
                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="state_id">State</Label>
                  <select name="state_id" className="form-control" value={addData.state_id || ""} onChange={handleAddInputChange}>
                    <option value="">Select State</option>
                    {states.map((state) => (
                      <option key={state.state_id} value={state.state_id}>{state.name}</option>
                    ))}
                  </select>
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="city">City</Label>
                  <Input name="city" type="text" className="form-control" value={addData.city || ""} onChange={handleAddInputChange} />
                </Col>

                {/* Additional Information Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="years_of_exp">Years of  Experience in Real Estate</Label>
                  <Input name="years_of_exp" type="number" className="form-control" value={addData.years_of_exp || ""} onChange={handleAddInputChange} />
                </Col>
				 <Col md="4" className="form-group">
                  <Label htmlFor="education_qualification">Highest Education Qualification</Label>
                 <select
					  name="education_qualification"
					  className="form-control"
					  value={addData.education_qualification || ""} // Default value is empty if no value is set
					  onChange={handleAddInputChange}
					>
					  <option value="">Select Qualification</option> {/* Add a placeholder option */}
					  <option value="Masters">Masters</option>
					  <option value="Graduate">Graduate</option>
					  <option value="Diploma">Diploma</option>
					  <option value="High School">High School</option>
					</select>

                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="company_name">Company Name</Label>
                  <Input name="company_name" type="text" className="form-control" value={addData.company_name || ""} onChange={handleAddInputChange} />
                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="company_gst">Company GST No.</Label>
                  <Input name="company_gst" type="text" className="form-control" value={addData.company_gst || ""} onChange={handleAddInputChange} />
                </Col>
				
                
                <Col md="12" className="form-group"  style={{ backgroundColor: '#f8f9fa', padding: '15px', borderRadius: '8px' }}>
  <h5 style={{ margin: 0 }}>Nominee Details</h5>
                </Col>

                {/* Nominee Details Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="nominee_name">Nominee Name</Label>
                  <Input name="nominee_name" type="text" className="form-control" value={addData.nominee_name || ""} onChange={handleAddInputChange} />
                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="nominee_relationship">Nominee Relationship</Label>
                  <Input name="nominee_relationship" type="text" className="form-control" value={addData.nominee_relationship || ""} onChange={handleAddInputChange} />
                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="nominee_contact">Nominee Contact No.</Label>
                  <Input name="nominee_contact" type="text" className="form-control" value={addData.nominee_contact || ""} onChange={handleAddInputChange} />
                </Col>
				
				<Col md="12" className="form-group" style={{ backgroundColor: '#f8f9fa', padding: '15px', borderRadius: '8px' }}>
  <h5 style={{ margin: 0 }}>Bank Details</h5>
</Col>
                {/* Bank Details Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="bank_name">Bank Name</Label>
                  <Input name="bank_name" type="text" className="form-control" value={addData.bank_name || ""} onChange={handleAddInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="account_number">Account Number</Label>
                  <Input name="account_number" type="text" className="form-control" value={addData.account_number || ""} onChange={handleAddInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="ifsc_code">IFSC Code</Label>
                  <Input name="ifsc_code" type="text" className="form-control" value={addData.ifsc_code || ""} onChange={handleAddInputChange} />
                </Col>
				</div>
				<div className="row">
                <Col md="4" className="form-group">
                  <Label htmlFor="account_type">Account Type</Label>
                  <select name="account_type" className="form-control" value={addData.account_type || ""} onChange={handleAddInputChange}>
                    <option value="Savings">Savings</option>
                    <option value="Current">Current</option>
                  </select>
                </Col>

                {/* Identification Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="pan">PAN</Label>
                  <Input name="pan" type="text" className="form-control" value={addData.pan || ""} onChange={handleAddInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="aadhar_number">Aadhar Number</Label>
                  <Input name="aadhar_number" type="text" className="form-control" value={addData.aadhar_number || ""} onChange={handleAddInputChange} />
                </Col>
				</div>
            </Form>
          </ModalBody>
          <ModalFooter>
            <Button color="primary" disabled={!isReferralValid} onClick={handleAddMember}>
              Add Member
            </Button>
            <Button color="secondary" onClick={() => setAddModal(false)}>
              Cancel
            </Button>
          </ModalFooter>
        </Modal>
      )}
      {editModal && (
        <Modal size="lg" isOpen={editModal} toggle={() => setEditModal(!editModal)}>
          <ModalHeader toggle={() => setEditModal(!editModal)}>Edit Team Member</ModalHeader>
          <ModalBody>
		  {errorMessage && <Alert color="danger">{errorMessage}</Alert>}
		   {successMessage && <Alert color="success">{successMessage}</Alert>}
            <Form>
			<div className="row">
               <Col md="4" className="form-group">
                  <Label htmlFor="title">Title</Label>
                 <select
					  name="title"
					  className="form-control"
					  value={editData.title || ""} // Default value is 'Mr' if 'title' is not provided
					  onChange={handleInputChange}
					>
					<option value="">Select Title</option>
					  <option value="Mr">Mr</option>
					  <option value="Ms">Ms</option>
					</select>
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="first_name">First Name</Label>
                  <Input name="first_name" type="text" className="form-control" value={editData.first_name || ""} onChange={handleInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="middle_name">Middle Name</Label>
                  <Input name="middle_name" type="text" className="form-control" value={editData.middle_name || ""} onChange={handleInputChange} />
                </Col>
                </div>
				<div className="row">
                <Col md="4" className="form-group">
                  <Label htmlFor="last_name">Last Name</Label>
                  <Input name="last_name" type="text" className="form-control" value={editData.last_name || ""} onChange={handleInputChange} />
                </Col>

                {/* Father's Name and Contact Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="father_name">Father's Name</Label>
                  <Input name="father_name" type="text" className="form-control" value={editData.father_name || ""} onChange={handleInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="mobile">Mobile</Label>
                  <Input name="mobile" type="text" className="form-control" value={editData.mobile || ""} onChange={handleInputChange} />
                </Col>
				</div>
				<div className="row">
                <Col md="4" className="form-group">
                  <Label htmlFor="email">Email</Label>
                  <Input name="email" type="email" className="form-control" value={editData.email || ""} onChange={handleInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="address">Address</Label>
                  <Input name="address" type="text" className="form-control" value={editData.address || ""} onChange={handleInputChange} />
                </Col>

                {/* Location Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="country_id">Country</Label>
                  <select name="country_id" className="form-control" value={editData.country_id || ""} onChange={handleInputChange}>
                    <option value="">Select Country</option>
                    {countries.map((country) => (
                      <option key={country.country_id} value={country.country_id}>{country.name}</option>
                    ))}
                  </select>
                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="state_id">State</Label>
                  <select name="state_id" className="form-control" value={editData.state_id || ""} onChange={handleInputChange}>
                    <option value="">Select State</option>
                    {states.map((state) => (
                      <option key={state.state_id} value={state.state_id}>{state.name}</option>
                    ))}
                  </select>
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="city">City</Label>
                  <Input name="city" type="text" className="form-control" value={editData.city || ""} onChange={handleInputChange} />
                </Col>

                {/* Additional Information Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="years_of_exp">Years of  Experience in Real Estate</Label>
                  <Input name="years_of_exp" type="number" className="form-control" value={editData.years_of_exp || ""} onChange={handleInputChange} />
                </Col>
				 <Col md="4" className="form-group">
                  <Label htmlFor="education_qualification">Highest Education Qualification</Label>
                 <select
					  name="education_qualification"
					  className="form-control"
					  value={editData.education_qualification || ""} // Default value is empty if no value is set
					  onChange={handleInputChange}
					>
					  <option value="">Select Qualification</option> {/* Add a placeholder option */}
					  <option value="Masters">Masters</option>
					  <option value="Graduate">Graduate</option>
					  <option value="Diploma">Diploma</option>
					  <option value="High School">High School</option>
					</select>

                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="company_name">Company Name</Label>
                  <Input name="company_name" type="text" className="form-control" value={editData.company_name || ""} onChange={handleInputChange} />
                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="company_gst">Company GST No.</Label>
                  <Input name="company_gst" type="text" className="form-control" value={editData.company_gst || ""} onChange={handleInputChange} />
                </Col>
				
                
                <Col md="12" className="form-group"  style={{ backgroundColor: '#f8f9fa', padding: '15px', borderRadius: '8px' }}>
  <h5 style={{ margin: 0 }}>Nominee Details</h5>
                </Col>

                {/* Nominee Details Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="nominee_name">Nominee Name</Label>
                  <Input name="nominee_name" type="text" className="form-control" value={editData.nominee_name || ""} onChange={handleInputChange} />
                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="nominee_relationship">Nominee Relationship</Label>
                  <Input name="nominee_relationship" type="text" className="form-control" value={editData.nominee_relationship || ""} onChange={handleInputChange} />
                </Col>
				
                <Col md="4" className="form-group">
                  <Label htmlFor="nominee_contact">Nominee Contact No.</Label>
                  <Input name="nominee_contact" type="text" className="form-control" value={editData.nominee_contact || ""} onChange={handleInputChange} />
                </Col>
				
				<Col md="12" className="form-group" style={{ backgroundColor: '#f8f9fa', padding: '15px', borderRadius: '8px' }}>
  <h5 style={{ margin: 0 }}>Bank Details</h5>
</Col>
                {/* Bank Details Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="bank_name">Bank Name</Label>
                  <Input name="bank_name" type="text" className="form-control" value={editData.bank_name || ""} onChange={handleInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="account_number">Account Number</Label>
                  <Input name="account_number" type="text" className="form-control" value={editData.account_number || ""} onChange={handleInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="ifsc_code">IFSC Code</Label>
                  <Input name="ifsc_code" type="text" className="form-control" value={editData.ifsc_code || ""} onChange={handleInputChange} />
                </Col>
				</div>
				<div className="row">
                <Col md="4" className="form-group">
                  <Label htmlFor="account_type">Account Type</Label>
                  <select name="account_type" className="form-control" value={editData.account_type || ""} onChange={handleInputChange}>
                    <option value="Savings">Savings</option>
                    <option value="Current">Current</option>
                  </select>
                </Col>

                {/* Identification Section */}
                <Col md="4" className="form-group">
                  <Label htmlFor="pan">PAN</Label>
                  <Input name="pan" type="text" className="form-control" value={editData.pan || ""} onChange={handleInputChange} />
                </Col>
                <Col md="4" className="form-group">
                  <Label htmlFor="aadhar_number">Aadhar Number</Label>
                  <Input name="aadhar_number" type="text" className="form-control" value={editData.aadhar_number || ""} onChange={handleInputChange} />
                </Col>
				</div>
            </Form>
          </ModalBody>
          <ModalFooter>
            <Button color="primary" onClick={handleUpdate}>
              Update
            </Button>{" "}
            <Button color="secondary" onClick={() => setEditModal(false)}>
              Cancel
            </Button>
          </ModalFooter>
        </Modal>
      )}
    </div>
  );
};

export default MyTeamTab;
