import Link from "next/link";
import React, { useState } from "react";
import { Logo } from "@/components/elements/Logo";
import { Container, Row } from "reactstrap";
import { FooterData } from "../../data/footerData";
import FooterBlog from "./elements/FooterBlog";
import FooterContactUsDetails from "./elements/FooterContactUsDetails";
import FooterLink from "./elements/FooterLink";
import FooterMap from "./elements/FooterMap";
import SubFooter from "./elements/SubFooter";

// Importing any necessary CSS for WhatsApp floating icon
import "./FloatingWhatsAppIcon.css"; // Optional CSS file to style the icon

const FooterFour = ({ logo }) => {
  const [isActive, setIsActive] = useState();
  
  /* return (
    <footer className="footer-light">
      <div className="footer">
        <Container>
          <Row>
            <FooterContactUsDetails
              logo={
                <Link href="/">
                  <img src="/assets/images/logo/4.png" className="for-light" alt="" />
                  <img src="/assets/images/logo/9.png" className="for-dark" alt="" />
                </Link>
              }
              isActive={isActive}
              setIsActive={setIsActive}
              liteFooter="true"
            />

            <FooterLink value={FooterData.about} isActive={isActive} setIsActive={setIsActive} liteFooter={6} />
            <FooterLink value={FooterData.buy} isActive={isActive} setIsActive={setIsActive} liteFooter={6} />
            <FooterLink value={FooterData.sell} isActive={isActive} setIsActive={setIsActive} liteFooter={6} />
            <FooterLink value={FooterData.relandEstate} isActive={isActive} setIsActive={setIsActive} liteFooter={6} />
          </Row>
        </Container>
      </div>
      <div className="sub-footer sub-footer-dark">
        <Container>
          <Row>
            <div className="col-xl-6 col-md-6">
              <div className="footer-social sub-footer-link">
                <ul>
                  <li>
                    <a href="https://www.facebook.com/">
                      <i className="fab fa-facebook-f"></i>
                    </a>
                  </li>
                  <li>
                    <a href="https://www.instagram.com/">
                      <i className="fab fa-instagram"></i>
                    </a>
                  </li>
                  <li>
                    <a href="https://twitter.com/">
                      <i className="fab fa-twitter"></i>
                    </a>
                  </li>
                  <li>
                    <a href="https://accounts.google.com/">
                      <i className="fab fa-google"></i>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
            <div className="col-xl-6 col-md-6 text-end">
              <div className="copy-right">
                <p className="mb-0">
                  Copyright © AnandMala Realty Pvt Ltd 2024. All Rights Reserved. Website Designed & Developed By Javin Global
                </p>
              </div>
            </div>
          </Row>
        </Container>
      </div>
      
      
      <a
        href="https://wa.me/9063291050" // Replace with your actual WhatsApp number
        className="floating-whatsapp-icon"
        target="_blank"
        rel="noopener noreferrer"
      >
        <i className="fab fa-whatsapp"></i>
      </a>
    </footer>
  );
}; */
 return (
    <footer className="footer-brown">
      <div className="footer footer-custom-col">
        <Container>
          <Row className="row">
            <FooterContactUsDetails isActive={isActive} setIsActive={setIsActive} logo={logo || <Logo />} />
            <FooterLink value={FooterData.about} isActive={isActive} setIsActive={setIsActive} />
            <FooterMap isActive={isActive} setIsActive={setIsActive} />
            <FooterLink value={FooterData.tag} isActive={isActive} setIsActive={setIsActive} />
            {/* <FooterBlog
              isActive={isActive}
              setIsActive={setIsActive}
              img={["/assets/images/footer/1.jpg", "/assets/images/footer/2.jpg"]}
            /> */}
          </Row>
        </Container>
      </div>
      <SubFooter />

      {/* Floating WhatsApp Icon */}
      <a
        href="https://wa.me/9063291050" // Replace with your WhatsApp number
        className="floating-whatsapp-icon"
        target="_blank"
        rel="noopener noreferrer"
      >
        <i className="fab fa-whatsapp"></i>
      </a>
    </footer>
  );
};

export default FooterFour;
