import React, { useState } from "react";
import { Col, Container, Row } from "reactstrap";
import { Logo } from "@/components/elements/Logo"; 
import { FooterData } from "../../data/footerData";
import FooterLink from "./elements/FooterLink";
//import FooterBlog from "./footerThreeElements/FooterBlog";
//import FooterContactUsDetails from "./footerThreeElements/FooterContactUsDetails";
import FooterContactUsDetails from "./elements/FooterContactUsDetails";
import FooterMap from "./elements/FooterMap";
import SubFooterTwo from "./elements/SubFooterTwo";
import SubFooter from "./elements/SubFooter";
import FooterBlog from "./elements/FooterBlog";

// Importing any necessary CSS for WhatsApp floating icon
import "./FloatingWhatsAppIcon.css"; // Optional CSS file to style the icon

const FooterThree = ({ logo }) => {
  const [isActive, setIsActive] = useState();

  /* return (
    <footer>
      <div className="footer footer-bg">
        <Container>
          <Row>
            
            <Col lg="4" xl="4">
              <FooterContactUsDetails />
            </Col>

           
            <Col lg="4" xl="4">
              <FooterBlog />
            </Col>

            
            <Col lg="4" xl="4">
              <div className="footer-links">
                <h5
                  className={`footer-title ${isActive === "subscribe" ? "active" : ""}`}
                  onClick={(e) => {
                    e.preventDefault();
                    setIsActive("subscribe");
                    isActive === "subscribe" && setIsActive();
                  }}
                >
                  Subscribe
                  <span className="according-menu">
                    <i className="fas fa-chevron-down"></i>
                  </span>
                </h5>
                <div className={`footer-content ${isActive === "subscribe" ? "d-block" : "d-none d-md-block"}`}>
                  <p className="mb-0">
                    Real estate investing involves the purchase, improvement of realty, management, and sale or rental of real estate for profit.
                  </p>
                  <form>
                    <div className="input-group">
                      <input type="email" className="form-control" placeholder="Email Address" required />
                      <span className="input-group-append">
                        <button type="submit" className="input-group-text" id="basic-addon2">
                          <i className="fas fa-paper-plane"></i>
                        </button>
                      </span>
                    </div>
                  </form>
                </div>
              </div>
            </Col>
          </Row>
        </Container>
      </div>
      <SubFooterTwo />
      
      
      <a
        href="https://wa.me/9063291050" // Replace with your actual WhatsApp number
        className="floating-whatsapp-icon"
        target="_blank"
        rel="noopener noreferrer"
      >
        <i className="fab fa-whatsapp"></i>
      </a>
    </footer>
  );
}; */
 return (
    <footer className="footer-brown">
      <div className="footer footer-custom-col">
        <Container>
          <Row className="row">
            <FooterContactUsDetails isActive={isActive} setIsActive={setIsActive} logo={logo || <Logo />} />
            <FooterLink value={FooterData.about} isActive={isActive} setIsActive={setIsActive} />
            <FooterMap isActive={isActive} setIsActive={setIsActive} />
            <FooterLink value={FooterData.tag} isActive={isActive} setIsActive={setIsActive} />
            <FooterBlog
              isActive={isActive}
              setIsActive={setIsActive}
              img={["/assets/images/footer/1.jpg", "/assets/images/footer/2.jpg"]}
            />
          </Row>
        </Container>
      </div>
      <SubFooter />

      {/* Floating WhatsApp Icon */}
      <a
        href="https://wa.me/9063291050" // Replace with your WhatsApp number
        className="floating-whatsapp-icon"
        target="_blank"
        rel="noopener noreferrer"
      >
        <i className="fab fa-whatsapp"></i>
      </a>
    </footer>
  );
};
export default FooterThree;
