/**
 * It returns a header element with a container element with a row element with a column element with a
 * div element with a logo element and two nav elements
 * @returns A header with a container with a row with a column with a div with a logo and two navs.
 */
import React, { Fragment } from "react";
import { Col, Row, Container } from "reactstrap";
import { Logo } from "@/components/elements/Logo";
import { Logoback } from "@/components/elements/Logo2";
import useStickyBar from "@/utils/useStickyBar";
import MainNav from "./elements/MainNav";
import RightNav from "./elements/RightNav";
import TopBarTwo from "./elements/TopBarTwo";

const NavbarOne = ({ logo, logoback, fixed }) => {
  const fix = useStickyBar();
  return (
    <Fragment>
      <TopBarTwo logo={logo} />
      {/* <header className={`header-1 ${fixed ? "fixed-header" : "header-6"} ${fixed && fix ? "fixed" : ""} `}> */}
      <header className={`bg-white header-3 fixed-header ${fix ? "fixed" : ""}`}>
        {/* <Container>
        <Row>
          <Col>
            <div className='menu'>
               {logo || <Logo />}
              <MainNav />
              <RightNav />
			       {logoback || <Logoback />}
            </div>
          </Col>
        </Row>
      </Container> */}
      </header>
    </Fragment>

  );
};

export default NavbarOne;
