import React, { useEffect, useState } from "react";
import {
  Col,
  Container,
  Dropdown,
  DropdownItem,
  DropdownMenu,
  DropdownToggle,
  Input,
  InputGroup,
  Row,
} from "reactstrap";
import { Logo, Logo2 } from "@/components/elements/Logo";
import useOutsideDropdown from "@/utils/useOutsideDropdown";
import RightNav from "./RightNav";
import SearchSuggestionBox from "@/components/elements/SearchSuggestionBox";
// import Cart from './rightNavComponents/Cart';
import { IoCallSharp } from "react-icons/io5";
import { FaUser, FaWhatsapp, FaFacebookF, FaInstagram, FaLinkedinIn, FaYoutube } from "react-icons/fa";
import { User, LogOut, Link } from "react-feather";
import LogoutButton from "@/components/common/LogoutButton";
import { FaXTwitter, FaThreads } from "react-icons/fa6";




const TopBarTwo = ({ logo }) => {
  const [dropDown, setDropDown] = useState(false);
  const [dropDownValue, setDropDownValue] = useState("Apartment");
  const [searchInput, setSearchInput] = useState("");
  const [searchDropDown, setSearchDropDown] = useState(false);
  const { ref, isComponentVisible, setIsComponentVisible } =
    useOutsideDropdown(false);

  const [isDropdownOpen, setDropdownOpen] = useState(false); // State to control dropdown visibility
  const [isLoggedIn, setIsLoggedIn] = useState(false); // State to track if user is logged in

  // Function to toggle dropdown on user icon click
  const toggleDropdown = () => {
    setDropdownOpen(!isDropdownOpen);
  };

  const token = localStorage.getItem("token");
  // Check if user is logged in based on token in local storage
  useEffect(() => {

    if (token) {
      setIsLoggedIn(true);
    }
  }, []);


  const handleLogout = async () => {
    try {


      // Make API call to logout
      if (token) {
        const response = await fetch(`${process.env.NEXT_PUBLIC_BASE_URL}/logout`, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
            Authorization: `Bearer ${token}`,
          },
        });
        if (response.data.message === "Unauthenticated.") {
          localStorage.clear();
          window.location.href = '/';
        }
        if (response.ok) {
          // On successful logout, clear the token and update the state
          localStorage.removeItem("token");
          setIsLoggedIn(false);
          // Optionally, you can redirect the user to the homepage or login page
          window.location.href = "/"; // Redirecting to home page
        } else {
          console.error("Logout failed");
        }
      }
    } catch (error) {
      console.error("Logout error: ", error);
      if (error.response && error.response.data && error.response.data.message === 'Unauthenticated.') {
        localStorage.clear();
        window.location.href = '/';
      }
    }
  };

  return (
    <div className="top-bar two light-bg-two">
      <Container>
        <Row>
          <Col>
            <div className="justify-between top-content top-nav two ">
              <ul class="user-login-wrapper">
                <li className="!flex">
                  <span>
                    <a href="#">
                      <FaFacebookF size={15} color="#1877F2"/>
                    </a>
                  </span>
                </li>
                <li className="!flex">
                  <span>
                    <a href="#">
                      <FaInstagram size={15} color="#E4405F"/>
                    </a>
                  </span>
                </li>
                <li className="!flex">
                  <span>
                    <a href="#" >
                      <FaLinkedinIn size={15} color="#0A66C2"/>
                    </a>
                  </span>
                </li>
                <li className="!flex">
                  <span>
                    <a href="#" >
                      <FaXTwitter size={15} color="#000000"/>
                    </a>
                  </span>
                </li>
                <li className="!flex">
                  <span>
                    <a href="#">
                      <FaYoutube size={15} color="#FF0000"/>
                    </a>
                  </span>
                </li>
                <li className="!flex">
                  <span>
                    <a href="#" >
                      <FaThreads size={15} color="#000000"/>
                    </a>
                  </span>
                </li>
                <li className="!flex">
                  <span>
                    <a href="https://api.whatsapp.com/send?phone=98490 43980">
                      <FaWhatsapp size={15} color="#00d300"/>
                    </a>
                  </span>
                </li>
              </ul>
              <ul>
                <li className="chat-with-us">
                  <a href="https://api.whatsapp.com/send?phone=98490 43980">
                    <button>Chat with Us</button>
                  </a>
                </li>
              </ul>
            </div>
          </Col>
        </Row>
      </Container>
    </div>
  );
};

export default TopBarTwo;
