/**
 * It renders a mega menu with nested child menus
 * @returns A React component.
 */
import React from "react";
import Link from "next/link";
import { Col, Container, Row } from "reactstrap";
import useMobileSize from "@/utils/useMobileSize";
import { useTranslation } from "react-i18next";

const MegaMenu = ({ navTitle, isOpen, setIsOpen, isOpenNestedChild, setIsOpenNestedChild }) => {
  const { t } = useTranslation("common");
  const mobileSize = useMobileSize();

  // Safely check for children before calling map
  const children = Array.isArray(navTitle.children) ? navTitle.children : [];

  return (
    <li className="mega-menu">
      {/* menuItem : PAGES */} {/* This all code for PAGES menu link*/}
    <a
    href={t(navTitle.title) === "CONTACT US" ? "#contactdetails" : "/"}
  className={`nav-link menu-title text-uppercase ${isOpen === navTitle.title && "active"}`}
  onClick={(e) => {
    e.preventDefault();
    if (t(navTitle.title) === "CONTACT US") {
      const contactSection = document.getElementById("contactdetails");
      if (contactSection) {
        contactSection.scrollIntoView({ behavior: "smooth" });
      }
    } else {
      setIsOpen(navTitle.title);
      isOpen === navTitle.title && setIsOpen();
    }
  }}
>
  {t(navTitle.title)}
  <span className="according-menu">
    {isOpen === navTitle.title ? "-" : "+"}
  </span>
</a>


      {/* <div className={`mega-menu-container menu-content ${isOpen === navTitle.title ? "d-block" : ""} `}>
        <Container>
          <Row>
           
            {children.map((childNavList, index) => {
              // Safely check for nested children
              const nestedChildren = Array.isArray(childNavList.children) ? childNavList.children : [];
              
              return (
                <Col className="mega-box" key={index}>
                 
                  {nestedChildren.map((nestedChildNavList, index) => (
                    <div className="link-section" key={index}>
                      <div className={`submenu-title ${isOpen === navTitle.title ? "active" : ""}`}>
                        <h5
                          onClick={(e) => {
                            e.preventDefault();
                            setIsOpenNestedChild(nestedChildNavList.title);
                            isOpenNestedChild === nestedChildNavList.title && setIsOpenNestedChild();
                          }}>
                          <a>{nestedChildNavList.title}</a>
                          {mobileSize && <span className="according-menu">{isOpenNestedChild === nestedChildNavList.title ? "-" : "+"}</span>}
                        </h5>
                      </div>
                      <div className={`submenu-content opensubmegamenu ${isOpenNestedChild === nestedChildNavList.title ? "d-block" : "d-none d-xl-block"}`}>
                        <ul className="list">
                          
                          {nestedChildNavList.children && Array.isArray(nestedChildNavList.children) && nestedChildNavList.children.map((nestedChildNavListTitle, index) => (
                            <li key={index}>
                              <Link href={nestedChildNavListTitle.path}>
                                {nestedChildNavListTitle.title}
                                {nestedChildNavListTitle.tag && <span className="label">{nestedChildNavListTitle.tag}</span>}
                                {nestedChildNavListTitle.icon && (
                                  <span className="icon-trend label">
                                    <i className="fas fa-bolt"></i>
                                  </span>
                                )}
                              </Link>
                            </li>
                          ))}
                        </ul>
                      </div>
                    </div>
                  ))}
                </Col>
              );
            })}
          </Row>
        </Container>
</div> */}
    </li>
  );
};

export default MegaMenu;
